(function($, Lego) {

Lego.block['b-window_mode_paranja'] = function(params) {
    var $this = $(this),
        timeout = false,
        $window = $this.find('.b-window');

    var api = {
        popup: function() {
            $this.removeClass('g-hidden');
            $(window).bind('resize', function() {
                if (timeout) return this;
                timeout = true;
                setTimeout(function() {
                    timeout = false;
                    moveToCenter();
                }, 5);
            });

            if($.browser.msie){
                $(window).bind("scroll.window", function () {
                    moveToCenter();
                });
            }
            moveToCenter();
            return this;
        },
        close: function() {
            $this.addClass('g-hidden');
        }
    };

    function moveToCenter() {
        var style = {};
        style.left = ($(window).width() / 2) - ($window.width() /2);
        style.top = ($(window).height() / 2) - ($window.height() / 2);
        style.position = 'fixed';

        fixOverrunning(style);
        $window.css(style);
    }

    function fixOverrunning(style) {
        //fix DIRECT-9911
        style.top = (style.top > 0) ? style.top : 0;
        style.left = (style.left > 0) ? style.left : 0;
    }

    $this.data('api', api)

};
})(jQuery, window.Lego);

