(function($, Lego) {

Lego.block['b-window'] = function(params) {
    var $this = $(this),
        attachment, position, closeOnClick, timeout = false;

    // TODO: проверить работу и применить чайнобилити для api
    var api = {
        attach: function(a, p, c, attachOnly, toggleOnClick) {
            if (attachment) api.detach();
            if (!attachment) $(window).bind('resize', function() {
                if (timeout) return this;
                timeout = true;
                setTimeout(function() {
                    timeout = false;
                    reposition();
                }, 5);
            });
            attachment = $(a);
            position = p || 'right bottom';
            closeOnClick = c;
            if (!attachOnly) {
                setTimeout(function() {
                    api.show();
                    reposition();
                }, 1)
            }
            return this;
        },

        popup: function() {
            $(window).bind('resize', function() {
                if (timeout) return this;
                timeout = true;
                setTimeout(function() {
                    timeout = false;
                    moveToCenter();
                }, 5);
            });

            if($.browser.msie){
                $(window).bind("scroll.window", function () {
                    moveToCenter();
                });
            }

            api.show();
            moveToCenter();
            return this;
        },

        attachment: function() {
            return attachment && attachment[0];
        },

        detach: function() {
            attachment = null;
            $this.trigger('b-window_detach');
            $(window)
                .unbind(".window")
                .unbind('resize', reposition);
            return this;
        },

        close: function() {
            var oe = $.Event('b-window_close');
            $this.trigger(oe);
            if (!oe.isDefaultPrevented()) $this.hide();
            return this;
        },


        submit: function() {
            var oe = $.Event('b-window_submit'), data;
            if ($.isFunction(api.submitData)) { data = api.submitData(); }
            $this.trigger(oe, data);
            if (!oe.isDefaultPrevented()) $this.hide();
            return this;
        },

        show: function() {
            $this
                .trigger('b-window_open')
                .removeClass('g-hidden')
                .show();
            if (BEM.blocks['b-popupa']) {
                BEM.blocks['b-popupa'].trigger('open');
            }
            if (attachment) reposition();
            return this;
        },
        
        toggle: function() {
            api[api.visible() ? 'close' : 'show']();
            return this;
        },
        
        visible: function() {
            return $this.is(':visible');
        }
    };

    api.open = api.show;

    $this
        .data('api', api)
        .trigger('b-window_api_ready')

        .find('.b-window__close, .b-window__cancel')
        .click(function() {
            api.close();
        })

        .end()
        .find('.b-window__submit')
        .click(function() {
            api.submit();
        });

    $(document)
        .bind('b-window_close-all', function(e) {
            api.close();
        })
        .click(function(e) {
            if (closeOnClick && api.visible() && e.target != $this[0] && $(e.target).parents('.b-window')[0] != $this[0]) api.close();
        });



    function moveToCenter() {
        var style = {};
        style.left = ($(window).width() / 2) - ($this.width() /2);
        if($.browser.msie){
            style.top = ($(window).height() / 2) - ($this.height() / 2) + $(document).scrollTop();
        } else {
            style.top = ($(window).height() / 2) - ($this.height() / 2);
            style.position = 'fixed';
        }

        fixOverrunning(style);
        $this.css(style);
    }

    function fixOverrunning(style) {
        //fix DIRECT-9911
        style.top = (style.top > 0) ? style.top : 0;
        style.left = (style.left > 0) ? style.left : 0;
    }

    function addPxSuffix(style) {
        style.top += 'px';
        style.left += 'px';   
    }

    function reposition () {
        if (!$this.is(':visible')) return;
        
        var pos = attachment.offset(),
            bodyOffset = $(document.body).offset(),
            style = {};
        pos.left -= bodyOffset.left;
        pos.top  -= bodyOffset.top;

        if (position.indexOf('left') > -1) {
            style.left = pos.left + attachment.width() - $this.width();
        } else if (position.indexOf('center') > -1) {
            style.left = pos.left + (attachment.width() - $this.width())/2;
        } else {
            style.left = pos.left;
        }

        //над родительским контейнером
        if (position.indexOf('top') > -1) {
            style.top = pos.top - attachment.height() - $this.height();
        //по центру контейнера
        } else if (position.indexOf('middle') > -1) {
            style.top = pos.top + (attachment.height() - $this.height())/2;
        //верхняя координата совпадает
        } else if (position.indexOf('t_equal') > -1) {
            style.top = pos.top;
        } else {
            style.top = pos.top + attachment.height();
        }
        fixOverrunning(style);
        addPxSuffix(style);
        $this.css(style);
    }
    
    if (params.attachment) {
        api.attach(params.attachment, params.position, false, !params.openOnLoad, params.toggleOnClick);
    }

};
})(jQuery, window.Lego);

