;(function($, Lego) {
    var charsLimit = 4096,
        ENTER_CODE = 13,
        COMMA_CODE = 44,
        url = '/registered/main.pl',
        request = BEM.create('i-request_type_ajax', {
            cache: true,
            url: SCRIPT,
            dataType: 'json',
            callbackCtx: this,
            type: 'POST'
        }),
        inputNames = ["request_count", "nonempty_answers", "clear_count", "add_one_phrase_count", "add_all_count", "added_phrases_count", 'refine_count'],
        confirmClearMessage = iget("Вы действительно хотите удалить все ключевые фразы?");

    Lego.block['b-word-suggestions'] = function(params) {
        var $this = $(this),
            bid = params.bid,
            model2 = BEM.blocks['i-models-manager'].get(params.modelPath, 'b-banner-edit'),
            otherPhrases = params.otherPhrases,
            elements = {},
            hasTips = params.hasTips,
            splitted = params.splitted && $(params.splitted),

            hiddenInputs = {},

            iteration = 0,
            lastUpdateText,
            upTimeout,
            onChangeTimeout,

            loadedTips,
            lastUrlPhrases;

        if (!hasTips) {
            $this.addClass('b-word-suggestions_hidden_tips')
        }

        var triggerChangeThrottle = $.throttle(function(event) {
            if (event == 'update' || event.which == COMMA_CODE
                || event.which == ENTER_CODE) {
                $this.trigger('b-word-suggestions_change'); // для совместимости с MoneyMetter
            }
        }, 1000);

        render();
        parse();
        attachThisControlToOldPhrases();
        createHiddenInuts();
        bindEvents();
        restoreHiddenState();
        adjustTemplateHint();

        if (otherPhrases) {
            //DIRECT-26404
            $(window).on('other-phrases-change', updatePhrasesCounter);
        }


        $this.addClass('b-word-suggestions_tips_no').addClass('b-word-suggestions_loaded_no');

        if (params.loadOnInit) {
            loadTips();
            onTextUpdate('update', false, true);
        } else {
            elements['tips-load'].show();
            onTextUpdate('update', true, true);
        }

        $this.data('api', {
            addAllPhrases: addAllPhrases,
            getAllPhrases: getAllPhrases,
            getAllPhrasesString: getAllPhrasesString,
            getPhrases: getPhrases,
            getLength: getLength,
            getCharsLeft: getCharsLeft,
            addPhrase: addPhrase,
            update: onUpdate
        });



        function attachThisControlToOldPhrases() {
            elements['old-phrases'].data('wordSuggestionsBlock', $this);
        }

        function appendPhrase (text) {
            var rawValue = $.trim(elements.phrases.val());
            if (
                text && rawValue && // есть текст в поле и есть текст для добавления
                    !elements.phrases.val().match(/(\n|,)\s*$/) // последий символ не запятая и не перевод каретки
                ) text = ', ' + text;

            elements.phrases.val(elements.phrases.val() + text);
        }

        function addPhrase(text) {
            text = $.trim(text);
            if ($.inArray(text, getAllPhrases()) != -1) return;

            appendPhrase(text);

            incHidden('added_phrases_count');
            incHidden('add_one_phrase_count');
            onTextUpdate('update');
        }

        function addAllPhrases(phrases) {
            var phrasesToAdd = [],
                allPhrases = getAllPhrases();
            for (var i = 0, l = phrases.length; i < l; i++) {
                if ($.inArray(phrases[i], allPhrases) == -1) {
                    phrasesToAdd.push(phrases[i]);
                    incHidden('added_phrases_count');
                }
            }

            appendPhrase(phrasesToAdd.join(', '));

            incHidden('add_all_count');
            onTextUpdate('update');
        }

        function getUnsplittedPhrases () {
            var phrases = $.trim(elements.phrases.val());
            if (phrases) {
                return $.grep(
                    $.map(
                        phrases.split(/\s*(?:\,|\r?\n)[\,\r\n\s]*/),
                        $.trim
                    ),
                    function( item ) { return item.length > 0; }
                );
            } else {
                return [];
            }

        }

        /* Собрать список новых фраз */
        function getPhrases() {
            var result = getUnsplittedPhrases();
            if (splitted) result = result.concat(splitted.data('api').getAllPhrases());

            return result;
        }

        function getOldPhrases () {
            var result = [];
            elements['old-phrases'].each(function(i, input) {
                var phrase = $.trim(input.value.replace(/,/, ''));
                if (!direct.utils.isEmpty(phrase)) result.push(phrase);
            });

            //нужно для корректной работы прогноза бюджета
            if (typeof(otherPhrases) != "undefined"){
                for (var i = 0; i < phrases.length; i++){
                    if(phrases[i].enable)
                        result.push(phrases[i].phrase);
                }
            }

            return result;
        }

        function getAllPhrasesString() {
            return getOldPhrases().concat(getPhrases()).join(',');
        }

        function getAllPhrases() {
            return getOldPhrases().concat(getPhrases());
        }

        function getLength() {
            return getAllPhrases().join(',').replace(/-!/g, '-').length;
        }

        function getCharsLeft() {
            return charsLimit - getLength();
        }

        /****/

        /* Установить таймаут для подсказок и прогнозатора */
        function setOnChangeTimeout(event, isInit) {
            clearOnChangeTimeout();
            onChangeTimeout = setTimeout(function() {
                if (lastUpdateText != getAllPhrases().join(',')) {
                    iteration = 0;
                    if (hasTips) {
                        loadTips();
                    }
                }
                updateModel(event, isInit);
            }, 1000);

        }

        /* Сбросить таймаут для подсказок и прогнозатора */
        function clearOnChangeTimeout() {
            if (onChangeTimeout) clearTimeout(onChangeTimeout);
        }


        /* Обновить счетчик фраз */
        function updatePhrasesCounter() {
            // TODO: сделать проверку на отрицательное значение
            var length = getCharsLeft();
            elements['word-counter']
                .toggleClass('b-word-suggestions_counter_overflow', length < 0)
                .html(length);
        }


        function parse () {
            $.each('successful-url-suggest phrases phrases-container label label-splitted tips refine-link tips-container order-link clear-link more-link before-link open-link close-link add-all-link word-counter old-phrases tips-list tips-message tips-load tips-load-link'.split(' '), function() {
                elements[this] = $('.b-word-suggestions__' + this, $this);
            });
            elements['old-phrases'] = $(params.oldPhrases || elements['old-phrases']);
            elements['open-link'] = $(params.openLink || elements['open-link']);
            elements['label'] = $(params.normalLabel || elements['label']);
            elements['label-splitted'] = $(params.splittedLabel || elements['label-splitted']);
        }

        function updateModel(event, isInit) {
            if (params.modelPath) model2[isInit ? 'initData' : 'update']({ all_phrases: getAllPhrasesString() });
        }



        function setUrlPhrasesTimeout() {
            if(model2.get('retargeting_conditions_id')) return;
            if (upTimeout) clearTimeout(upTimeout);
            upTimeout = setTimeout(function(){
                onUrlChanged({
                    url: model2.getChildModel('b-banner-form-href').get('href'),
                    urlProtocol: model2.getChildModel('b-banner-form-href').get('urlProtocol')
                });
            }, 500);
        }

        function loadTips() {
            $this.removeClass('b-word-suggestions_loaded_no');

            onTipsUpdated({
                phrases: [],
                is_something_after: '',
                is_something_before: ''
            });

            var phrases = getAllPhrases();

            lastUpdateText = phrases.join(',');
            elements['tips-list'].html('');

            if (phrases.length > 0) {
                elements['tips-container'].addClass('b-word-suggestions_tips_loading');

                request.get({
                        cmd: 'ajaxGetSuggestion',
                        srcPhrases: phrases.join(','),
                        n: 10,
                        brief: 'yes',
                        iteration: iteration
                    }, function(result) {
                        processNewTips({
                            phrases: result.phrases || [],
                            is_something_after: result.is_something_after,
                            is_something_before: result.is_something_before
                        });
                    }, function() {
                        processNewTips({
                            phrases: [],
                            is_something_before: '',
                            is_something_after: ''
                        });
                    });

                incHidden("request_count");
            } else {
                showMessage(iget('Укажите одну или несколько ключевых фраз&hellip;'));
                setInstructionHidden(true);
            }
        }

        function onTextUpdate(event, skipSchedule, isInit) {
            skipSchedule || setOnChangeTimeout(event, isInit);
            updatePhrasesCounter();
            triggerChangeThrottle(event);
            $this
                .toggleClass('b-word-suggestions_phrases_no', getUnsplittedPhrases().length == 0)
                .toggleClass('b-word-suggestions_all_phrases_no', getAllPhrases().length == 0);
            if (hiddenInputs.value) hiddenInputs.value.val(getPhrases());
        }

        function bindEvents () {
            elements['clear-link'].click(function() {
                if (params.confirmClear && !confirm(iget(confirmClearMessage))) return;
                elements.phrases.val('');
                incHidden('clear_count');
                onTextUpdate('update');

            });

            if (hasTips) {
                elements['more-link'].click(function() {
                    iteration += 1;
                    clearOnChangeTimeout();
                    loadTips();
                });

                elements['before-link'].click(function() {
                    iteration = 0;
                    clearOnChangeTimeout();
                    loadTips();
                });
            }


            elements['order-link'].click(function() {
                var phrases = unique(getPhrases());
                if (Lego.params.locale != 'tr') {
                    phrases.sort();
                } else {
                    phrases.sort(direct.utils.sortTr);
                }
                elements.phrases.val(phrases.join(",\n"));
            });

            elements['refine-link'].click(onSplit);

            elements['add-all-link'].click(function() {
                addAllPhrases(loadedTips);
                onTextUpdate('update');
            });

            elements['close-link'].click(function() {
                setHidden(true);
            });

            elements['open-link'].click(function() {
                setHidden(false);
            });

            elements['tips-load-link'].click(function() {
                if (getAllPhrases().length) {
                    elements['tips-load'].hide();
                    loadTips();
                }
            });

            if (splitted) {
                splitted.bind('b-word-suggestions__splitted_keyup', onTextUpdateByKey);
                splitted.bind('b-word-suggestions__splitted_change', onUpdate);
                splitted.bind('b-word-suggestions__splitted_remove', updateSplitted);
            }
            model2.on('prepare', onUpdate);

            elements['phrases'].bind('keyup', function(e, data) {
                setTimeout(function() { onTextUpdateByKey(e, data) }, 0);
            });
            elements['phrases'].bind('blur', onUpdate);
            elements['old-phrases'].bind('keyup', onTextUpdateByKey);
            elements['old-phrases'].bind('blur', onUpdate);

            if (params.modelPath) {
                model2.getChildModel('b-banner-form-href').on('finishEditing.url', setUrlPhrasesTimeout);
                model2.getChildModel('b-banner-form-href').onField('href', 'change', adjustTemplateHint);
                model2.onField('title body', 'change', adjustTemplateHint);
            }

            $(document).on('updateFromWordstat', function() {
                onTextUpdate('update');
            });

        }

        function adjustTemplateHint() {
            if (params.modelPath) {
                var noTemplate = (model2.get('title').match(/\#([^\#]*?)\#/g) || model2.get('body').match(/\#([^\#]*?)\#/g) || model2.getChildModel('b-banner-form-href').get('href').match(/\#([^\#]*?)\#/g)) ? false : true;
                if (params.templateHint) {
                    $(params.templateHint).toggleClass('g-hidden', noTemplate)
                }

            }
        }

        function onTextUpdateByKey(e) {
            onTextUpdate(e, false);
        }

        function updateSplitted () {
            var phrases = splitted.data('api').getAllPhrases();
            elements['label'].toggle(!phrases.length);
            elements['label-splitted'].toggle(!!phrases.length);
        }

        function onSplitComplete (result) {
            var error = $(result).find('error');
            if (error.length > 0) {
                var errorCode = error.text();
                alert(errorCode);
            } else {
                var phrases = $.map( $(result).find('phrase'), function(p) { return $(p).text(); }),
                    index = {};
                $.each(splitted.data('api').getAllPhrases().concat(getOldPhrases()), function() {
                    index[stripMinusWords(this)] = true;
                });
                phrases = $.grep(phrases, function(p) {
                    return !index[stripMinusWords(p)];
                });
                $.each(phrases, function(i, phrase) {
                    splitted.data('api').addPhrase(phrase, $this);
                });
                elements.phrases.val('');
                onTextUpdate('update');
                updateSplitted();
            }
        }

        function onSplit () {
            var index = {};
            $.ajax({
                url: '/registered/main.pl',
                dataType: 'xml',
                data: {
                    cmd: 'ajaxTestPhrases',
                    phrases: unique(getUnsplittedPhrases()).join(',')
                },
                type: 'POST',
                success: onSplitComplete
            });
            incHidden('refine_count');
        }

        function onUpdate (e, data) {
            if (data && data.deferred) {
                updateModel(e, false);
                data.deferred.resolve();
            } else {
                onTextUpdate('update');
            }
        }

        function incHidden(name) {
            hiddenInputs[name].val(hiddenInputs[name].val() * 1 + 1);
        }

        function restoreHiddenState(){
            if (!bid) return; // не восстанавливать состояние для новых подсказок
            var c = direct.UserOptions.get('word_suggestions');
            if (c && c != 'false') {
                setHidden(true);
            }
        }

        function processNewTips(result) {
            onTipsUpdated(result);
            var tips = result.phrases || [];
            if (tips.length != 0) {
                renderTips(tips);
                incHidden("nonempty_answers");
                hideMessage();
                setInstructionHidden(false);
            } else {
                showMessage(iget('Нет подсказок для данного набора ключевых фраз'));
                setInstructionHidden(true);
            }
            elements['tips-container'].removeClass('b-word-suggestions_tips_loading');
        }

        function onTipsUpdated(result) {
            elements['more-link'].toggle(!!result.is_something_after);
            elements['before-link'].toggle(!!result.is_something_before && !result.is_something_after);

            var tips = result.phrases || [];
            loadedTips = tips ;
            $this.toggleClass('b-word-suggestions_tips_no', tips.length == 0);
        }

        function renderTips(tips) {
            elements['tips-list'].html('');

            for (var i = 0, l = tips.length; i < l; i++) {
                var node = $('<li class="b-word-suggestions__tip"><span class="b-word-suggestions__tip-link">' + direct.utils.escapeHTML(tips[i]) + '</span></li>')
                    .data('word', tips[i]);

                $('span', node).click(function() {
                    addPhrase($(this).parent().data('word'));
                    onTextUpdate('update');
                });
                elements['tips-list'].append(node);
            }
        }

        function showMessage(text) {
            elements['tips-message'].html(text).show();
        }

        function hideMessage() {
            elements['tips-message'].hide();
        }

        function setHidden(state) {
            $this.toggleClass('b-word-suggestions_hidden_tips', state);
            elements['open-link'].toggle(state);
            direct.UserOptions.set('word_suggestions', state + '');

            elements['tips-container'].toggle(!state);// force redraw in IE
            setInstructionHidden(state || loadedTips.length == 0 );
        }

        function setInstructionHidden(state) {
            state = state || elements['tips-container'].is(":hidden");
            if (params.instruction) $(params.instruction).toggle(!state);
        }

        function onUrlChanged(params) {
            var url = params.url;
            var protocol = params.urlProtocol;
            if (getAllPhrases().length != 0 || !direct.utils.validateHref(url)) return;

            lastUrlPhrases = url.replace(/\+/g, '%20');
            $.ajax({
                type: 'get',
                dataType: 'text',
                url: SCRIPT,
                success: function(data) {
                    var result = eval('(' + data + ')');
                    if (result.url != lastUrlPhrases || getAllPhrases().length != 0) return;
                    elements['successful-url-suggest'].val(1);
                    addAllPhrases(result.phrases);
                },
                data: {
                    cmd: 'ajaxGetUrlPhrases',
                    detail: 0,
                    url: params.url,
                    url_protocol: protocol
                }
            });
        }

        function createHiddenInuts () {
            var suffix = bid ? '_' + bid : '';

            $.each(inputNames, function() {
                hiddenInputs[this] = $('<input type="hidden" name="suggest_' + this + '" value="0">');
                hiddenInputs[this].appendTo($this);
            });
            if (params.saveToHidden) {
                hiddenInputs.value = $('<input type="hidden" class="b-word-suggestions__hidden" name="' + params.saveToHidden + '" value="">');
                hiddenInputs.value.appendTo($this).bind('change', updateFromHidden);
            }
        }

        function updateFromHidden () {
            var index = {};
            $.each(getAllPhrases(), function() {
                index[stripMinusWords(this)] = true;
            });
            var newPhrases = $.grep(hiddenInputs.value.val().split(/\s*,\s*/), function(phrase) {
                return !index[stripMinusWords(phrase)];
            });
            if (newPhrases.length) appendPhrase(newPhrases.join(', '));
            onTextUpdate('update');
        }

        function render () {
            var openLink = BEM.HTML.build({
                block: 'b-word-suggestions',
                elem: 'close-link',
                tag: 'span',
                content: {
                    tag: 'span',
                    block: 'b-pseudo-link',
                    content:  iget('скрыть')
                }
            });
            var tips = BEM.HTML.build([
                {
                    block: 'b-word-suggestions',
                    elem: 'toolbar-header',
                    content: {
                        tag: 'h3',
                        block: 'b-word-suggestions',
                        elem: 'toolbar-header-title',
                        content: iget('Подсказки') + ' ' +
                            (params.openLink ? openLink : '')
                    }
                },
                {
                    block: 'b-word-suggestions',
                    elem: 'tips',
                    content: [
                        {
                            tag: 'p',
                            block: 'b-word-suggestions',
                            elem: 'tips-message',
                            content:  iget('Укажите одну или несколько ключевых фраз…')
                        },
                        {
                            block: 'b-word-suggestions',
                            elem: 'tips-list',
                            tag: 'ul'
                        },
                        {
                            tag: 'p',
                            block: 'b-word-suggestions',
                            elem: 'tips-load',
                            attrs: {'style': "dispaly: none"},
                            content:  {
                                block: 'b-word-suggestions',
                                elem: 'tips-load-link',
                                tag: 'span',
                                cls: 'b-pseudo-link',
                                content: iget('Загрузить подсказки')
                            }
                        }
                    ]
                },
                {
                    block: 'b-word-suggestions',
                    elem: 'toolbar-more',
                    content: [
                        {
                            block: 'b-word-suggestions',
                            elem: 'before-link',
                            content: {
                                tag: 'span',
                                cls: 'b-pseudo-link',
                                content: iget('в начало')
                            }
                        },
                        {
                            block: 'b-word-suggestions',
                            elem: 'more-link',
                            content: {
                                tag: 'span',
                                cls: 'b-pseudo-link',
                                content: iget('еще')
                            }
                        }
                    ]
                },
                {
                    block: 'b-word-suggestions',
                    elem: 'toolbar',
                    content: {
                        elem: 'add-all-link',
                        block: 'b-word-suggestions',
                        content: {
                            tag: 'span',
                            cls: 'b-pseudo-link',
                            content: iget('все подходят')
                        }
                    }
                },
                {
                    block: 'b-word-suggestions',
                    elem: 'tips-spacer'
                }
            ]);

            var element =  BEM.HTML.build({
                tag: 'table',
                block: 'b-word-suggestions',
                elem: 'table',
                content: {
                    tag: 'tr',
                    content: [
                        {
                            tag: 'td',
                            cls: 'b-word-suggestions__td',
                            block: 'b-word-suggestions',
                            elem: 'phrases-container',
                            content: [
                                {
                                    tag: 'textarea',
                                    content:  direct.utils.escapeHTML(params.value)
                                },
                                !!params.isNew && {
                                    tag: 'input',
                                    attrs: {type: 'hidden', value: 0, name: "suggest_by_url_successful"},
                                    elem: 'successful-url-suggest',
                                    block: 'b-word-suggestions'
                                },
                                {
                                    elem: 'toolbar',
                                    block: 'b-word-suggestions',
                                    content: [
                                        {
                                            block: 'b-word-suggestions',
                                            elem: 'clear-link',
                                            content: {
                                                tag: 'span',
                                                cls: "b-pseudo-link",
                                                content: iget('очистить')
                                            }
                                        },
                                        !params.splitted && {
                                            block: 'b-word-suggestions',
                                            elem: 'order-link',
                                            content: {
                                                tag: 'span',
                                                cls: "b-pseudo-link",
                                                content: iget('упорядочить')
                                            }
                                        },
                                        !!params.splitted && {
                                            block: 'b-word-suggestions',
                                            elem: 'refine-link',
                                            content: {
                                                tag: 'span',
                                                cls: "b-pseudo-link",
                                                content: iget('упорядочить и уточнить')
                                            }
                                        },
                                        {
                                            block: 'b-word-suggestions',
                                            elem: 'word-counter',
                                            content: charsLimit
                                        }
                                    ]
                                }

                            ]
                        },
                        {
                            tag: 'td',
                            cls: 'b-word-suggestions__td',
                            block: 'b-word-suggestions',
                            elem: 'tips-container',
                            content: hasTips ? tips : ''
                        }
                    ]
                }
            });

            element = $(element);

            $('textarea', element).replaceWith($('textarea', $this).addClass('b-word-suggestions__phrases'));
            $this.prepend(element);

        }

        function generateId(phrases) {
            return phrases.sort().join(',') + '&' + iteration;
        }

        function unique (array) {
            var ret = [],
                done = {};

            for ( var i = 0, length = array.length; i < length; i++ ) {
                var id = stripMinusWords(array[ i ]);

                if ( !done[ id ] ) {
                    done[ id ] = true;
                    ret.push( array[ i ] );
                }
            }
            return ret;
        }

        var stripRE = /\s+-.*/;
        function stripMinusWords (phrase) {
            return phrase.replace(stripRE, '');
        }

    };
})(jQuery, window.Lego);
