(function($, Lego) { 
    
Lego.block['b-word-suggestions__splitted'] = function(params) {
    var $this = $(this),
        container = $this.parents('.b-word-suggestions__splitted-container:eq(0)');

    $this.data('api', {
        addPhrase: addPhrase,
        getAllPhrases: getAllPhrases
    });
    
    function addPhrase (phrase, wordSuggestionsBlock) {
        container.show();
        
        var html = 
            '<table class="b-pf__action-c">' +
                '<tr>' +
                    '<td class="b-pf__action__input-c">' +
                        '<input value="' + direct.utils.escapeHTML(phrase) + '" tabindex="1" class="b-word-suggestions__splitted__input b-pf__input b-pf__action__input" />' +
                    '</td>' +
                    '<td class="b-pf__action__action-c">' +
                        '<span class="b-pf__action">' + iget('уточнить') + '</span>' +
                    '</td>' +
                '</tr>' +
            '</table>',
            node = $(html);
            
        $this.append(node);
        $('.b-word-suggestions__splitted__input', node)
            .bind('keyup', onKeyup)
            .bind('blur change', onChange)
            .blur(function() {
                if (!this.value.match(/\S/)) node.remove();
                $this.trigger('b-word-suggestions__splitted_remove');
                container.toggle(!!$('.b-word-suggestions__splitted__input', $this).length);
            })
            .data('wordSuggestionsBlock', wordSuggestionsBlock ? wordSuggestionsBlock : {});
    }
    
    function getAllPhrases () {
        return $.grep(
            $.map(
                $('.b-word-suggestions__splitted__input', $this), 
                function(input) { return $.trim(input.value); }
            ),
            function(v) { return !!v; }
        );
    }
    
    function onKeyup () {
        $this.trigger('b-word-suggestions__splitted_keyup');
    }
    
    function onChange () {
        $this.trigger('b-word-suggestions__splitted_change');
    }
};
})(jQuery, window.Lego);
