(function($, Lego) {

    BEM.DOM.decl('b-worktime-clonator', {
        onSetMod: {
            js: function() {
                this.bindTo('add', 'click', this._onAddClick);
                this.bindTo('remove', 'click', this._onRemoveClick);
                this.data = this.params.data;
                this.channel('worktime' + this.params.channelId).on('update-clonator', $.proxy(this.updateButtons, this));
            }
        },

        _onAddClick: function() {
            this.channel('worktime' + this.params.channelId).trigger('add');
        },

        _onRemoveClick: function() {
            this.channel('worktime' + this.params.channelId).trigger('remove');
        },

        updateButtons: function(e, data) {
            this.elem('add').toggleClass('g-hidden', data.addHidden);
            this.elem('remove').toggleClass('g-hidden', data.removeHidden);
        }

    });

    BEM.HTML.decl('b-worktime-clonator', {
        onBlock : function(ctx) {
            ctx
                .tag('div')
                .js({channelId: ctx.param('cnannelId') || $.identify(ctx)})
                .content({
                    tag: 'div',
                    content: [
                        {
                           tag: 'div',
                           cls: 'b-worktime-clonator__btn' + (ctx.param('has-remove') ? '' : ' g-hidden'),
                           elem: 'remove'
                        },
                        {
                            tag: 'div',
                            cls: 'b-worktime-clonator__btn' + (ctx.param('has-add') ? '' : ' g-hidden'),
                            elem: 'add'
                        }
                    ]
                });

        }
    });

})(jQuery, window.Lego);
