(function($, Lego) {
    var days = iget('пн вт ср чт пт сб вс').split(' ');

    BEM.DOM.decl('b-worktime-day', {
        onSetMod: {
            js: function() {
                var _this = this;

                this.bindTo('all-week', 'click', function(){
                    _this.channel('worktime' + this.params.channelId).trigger('all-week');
                });

                this
                    .bindTo('from', 'change', this._triggerChange)
                    .bindTo('to', 'change', this._triggerChange);

                this._triggerChange();
            }
        },

        toggleAllDayLink: function(visible) {
            this.setMod('all-week', visible ? 'yes' : 'no');
        },

        _triggerChange: function() {
            this.channel('worktime' + this.params.channelId).trigger('change-day',this.getDay());
        },

        _onToChange: function() {
            this._triggerChange()
        },

        _onFromChange: function() {
            var from = this.elem('from').val(),
                to = this.elem('to').val();
            this._updateToControl(from, to);
            this._triggerChange()

        },

        getDay: function() {
            return [this.elem('from').val(), this.elem('to').val()];
        },

        setDay: function(from, to) {
            this.elem('from').val(from);
            this.elem('to').val(to);

        },




        _updateToControl: function(from, to) {
            this.__self.update(this.elem('to-wrap'),
                BEM.HTML.build([
                    {
                        tag: 'label',
                        content: iget('&nbsp;по&nbsp;')
                    },
                    {
                        block: 'b-worktime-select',
                        mix: [{block: 'b-worktime-day', elem: 'to'}],
                        options: days,
                        start: from,
                        selected: to
                    }
                ])
            );
            //сбрасываем кэш, иначе в следующий раз будем работать с закэшированным элементом, а не с новым
            this.dropElemCache('to');
        }

    });

    BEM.HTML.decl('b-worktime-day', {
     onBlock : function(ctx) {
        ctx
            .tag('div')
            .mods({'all-week' : ctx.param('has-all-week') ? 'yes' : 'no'})
            .content([

            {
                tag: 'div',
                elem: 'wrapper',
                content: [
                    {
                        tag: 'span',
                        elem: 'from-wrap',
                        content: [{
                            tag: 'label',
                            content: iget('с&nbsp;')
                        },{
                            block: 'b-worktime-select',
                            mix: [{block: 'b-worktime-day', elem: 'from'}],
                            disabled: ctx.param('disabled'),
                            selected: ctx.param('day-from'),
                            options: days
                        }]

                    },
                    {
                        tag: 'span',
                        elem: 'to-wrap',
                        content: [{
                            tag: 'label',
                            content: iget('&nbsp;по&nbsp;')
                        }, {
                            block: 'b-worktime-select',
                            options: days,
                            selected: ctx.param('day-to'),
                            disabled: ctx.param('disabled'),
                            mix: [{block: 'b-worktime-day', elem: 'to'}]
                        }]
                    }
                ]
            },
            {
                tag: 'a',
                block: 'b-pseudo-link' ,
                mods: {'is-bem': 'yes'},
                cls: 'g-common__small',
                mix: [{block: 'b-worktime-day', elem: 'all-week'}],
                js: true,
                content: iget('ежедневно')
            }

        ])
        .js({channelId: ctx.param('cnannelId') || $.identify(ctx)})
     }
   });
})(jQuery, window.Lego);
