(function($, Lego) {
    var hours = '00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24'.split(' '),
        minutes = '00 15 30 45'.split(' '),
        hoursOnly = '00:00 01:00 02:00 03:00 04:00 05:00 06:00 07:00 08:00 09:00 10:00 11:00 12:00 13:00 14:00 15:00 16:00 17:00 18:00 19:00 20:00 21:00 22:00 23:00 24:00'.split(' ');

    BEM.DOM.decl('b-worktime-time', {
        onSetMod: {
            js: function() {
                this
                    .bindTo('all-day', 'click', this.setAllDay)
                    .bindTo('hour-from', 'change', this._triggerChange)
                    .bindTo('hour-to', 'change', this._triggerChange)
                    .bindTo('min-from', 'change', this._triggerChange)
                    .bindTo('min-to', 'change', this._triggerChange);

                this._triggerChange();
            }
        },

        _triggerChange: function() {
            this.channel('worktime' + this.params.channelId).trigger('change-time', this.getTime());
        },

        setDisabled: function(disabled) {
            this.elem('hour-from')
                .add(this.elem('min-from'))
                .add(this.elem('hour-to'))
                .add(this.elem('min-to'))
                    .prop('disabled', !!disabled);
        },

        setTime: function(hourFrom, minFrom, hourTo, minTo) {
            this.elem('hour-from')
                .val(hourFrom)
                .find('option[value="' + parseInt(hourFrom) + '"]').attr('selected', 'selected');
            this.elem('min-from').val(minFrom);
            this.elem('hour-to')
                .val(hourTo)
                .find('option[value="' + parseInt(hourTo) + '"]').attr('selected', 'selected');
            this.elem('min-to').val(minTo);
        },

        getTime: function() {
            return [
                this.elem('hour-from').val(),
                this.elem('min-from').val(),
                this.elem('hour-to').val(),
                this.elem('min-to').val()
            ]
        },

        setHourToBound: function(bound) {
            var val = +this.elem('hour-to').val(),
                selected = val <= bound ? bound + 1 : val;
            this.elem('hour-to-wrap').html(BEM.HTML.build({
                block: 'b-worktime-select',
                options: hoursOnly,
                start: bound + 1, end: 24,
                selected: selected,
                mix: [{block: 'b-worktime-time', elem: 'hour-to'}]
            }));
            this.dropElemCache('hour-to');
            this.bindTo('hour-to', 'change', this._triggerChange);
            this._triggerChange();
        },

        setAllDay: function() {
            this.setTime('0', '00', '24', '00');
            this._triggerChange();
        }

    });

    BEM.HTML.decl('b-worktime-time', {
     onBlock : function(ctx) {
        ctx
            .tag('div')
            .mods({'all-day': 'yes'})
            .content([

            {
                tag: 'div',
                elem: 'wrapper',
                content: [
                    {
                        tag: 'span',
                        elem: 'hour-from-wrap',
                        content: [
                            {
                            block: 'b-worktime-select',
                            mix: [{block: 'b-worktime-time', elem: 'hour-from'}],
                            start: 0, end: 23,
                            'disabled': ctx.param('disabled'),
                            selected: ctx.param('hour-from'),
                            options: ctx.param('hours-only') ? hoursOnly : hours
                        }]

                    },
                    !ctx.param('hours-only') && {
                        tag: 'span',
                        content: '&nbsp;:&nbsp;'
                    },
                    !ctx.param('hours-only') && {
                        tag: 'span',
                        elem: 'min-from-wrap',
                        content: {
                            block: 'b-worktime-select',
                            options: minutes,
                            values: minutes,
                            'disabled': ctx.param('disabled'),
                            selected: $.inArray(ctx.param('min-from'), minutes) > 0 ? $.inArray(ctx.param('min-from'), minutes) : 0,
                            mix: [{block: 'b-worktime-time', elem: 'min-from'}]
                        }
                    },
                    {
                        tag: 'span',
                        content: '&nbsp;&mdash;&nbsp;'
                    },
                    {

                        tag: 'span',
                        elem: 'hour-to-wrap',
                        content: {
                            block: 'b-worktime-select',
                            start: 0, end: 24,
                            options: ctx.param('hours-only') ? hoursOnly : hours,
                            'disabled': ctx.param('disabled'),
                            selected: ctx.param('hour-to'),
                            mix: [{block: 'b-worktime-time', elem: 'hour-to'}]
                        }
                    },
                    !ctx.param('hours-only') && {
                        tag: 'span',
                        content: '&nbsp;:&nbsp;'
                    },
                    !ctx.param('hours-only') && {
                        tag: 'span',
                        elem: 'min-to-wrap',
                        content: {
                            block: 'b-worktime-select',
                            options: minutes,
                            values: minutes,
                            'disabled': ctx.param('disabled'),
                            selected: $.inArray(ctx.param('min-to'), minutes) > 0 ? $.inArray(ctx.param('min-to'), minutes) : 0,
                            mix: [{block: 'b-worktime-time', elem: 'min-to'}]
                        }

                    }
                ]
            },
            ctx.param('all-day') && {
                tag: 'a',
                block: 'b-pseudo-link',
                mods: {'is-bem': 'yes'},
                cls: 'g-common__small' + ((ctx.param('all-day') == 'yes' && !ctx.param('disabled')) ? '' : ' g-hidden') ,
                mix: [{block: 'b-worktime-time', elem: 'all-day'}],
                js: true,
                content: iget('круглосуточно')
            }

        ])
        .js({channelId: ctx.param('cnannelId') || $.identify(ctx)})
     }
   });
})(jQuery, window.Lego);
