(function($, Lego) {

    BEM.DOM.decl('b-worktime', {
        onSetMod: {
            'js': function() {
                this.day = this.findBlockInside('b-worktime-day');
                this.time = this.findBlockInside('b-worktime-time');
            }
        },

        toggleAllDayLink: function(visible) {
            this.day && this.day.toggleAllDayLink(visible)
        },

        getChannelName: function() {
            return 'worktime' + this.params.channelId;
        },

        getChannel: function() {
            return this.channel('worktime' + this.params.channelId)
        },

        setDisabled: function(disabled) {
            this.toggleMod('disabled', disabled ? 'yes' : 'no');
            if (this.day) {
               this.day.setDisabled(disabled)
            }
            this.time.setDisabled(disabled)
        },

        setTime: function(time) {
            this.day && this.day.setDay(time['day-from'] || time['dayFrom'], time['day-to'] || time['dayTo']);

            this.time.setTime(
                time['hour-from'] || time['hourFrom'],
                time['min-from'] || time['minFrom'],
                time['hour-to'] || time['hourTo'],
                time['min-to'] || time['minTo']
            );
        },

        getTime: function() {
            var time = [];
            if (this.day) {
                time = time.concat(this.day.getDay());
            }
            return time.concat(this.time.getTime());
        }
    });

    BEM.HTML.decl('b-worktime', {
         onBlock : function(ctx) {
            var cnannelId = $.identify(ctx);
            ctx
                .tag('div')
                .js({channelId: cnannelId})
                .content([
                    ctx.param('has-day') == 'yes' &&
                    {
                         block: 'b-worktime-day',
                         cnannelId: cnannelId,
                        'day-from': ctx.param('day-from'),
                        'disabled': ctx.param('disabled'),
                        'day-to': ctx.param('day-to'),
                        'has-all-week': ctx.param('has-all-week'),
                         mix: [{block: 'b-worktime', elem: 'day'}]
                    },
                    {
                        block: 'b-worktime-time',
                        cnannelId: cnannelId,
                        'hours-only': ctx.param('hours-only'),
                        'disabled': ctx.param('disabled'),
                        'all-day': ctx.param('all-day'),
                        'hour-from': ctx.param('hour-from'),
                        'hour-to': ctx.param('hour-to'),
                        'min-from': ctx.param('min-from'),
                        'min-to': ctx.param('min-to'),
                         mix: [{block: 'b-worktime', elem: 'time'}]
                    },
                    {
                         block: 'b-worktime-clonator',
                         cnannelId: cnannelId,
                        'disabled': ctx.param('disabled'),
                        'has-add': ctx.param('has-add'),
                         mix: [{block: 'b-worktime', elem: 'clonator'}],
                        'has-remove': ctx.param('has-remove')
                    }
                ])

         }
    });

})(jQuery, window.Lego);
