(function($, Lego) { 
    
Lego.block['b-xls-form__mode_csv'] = function(params) {
    var $this = $(this),
        optionsForm = $('form:eq(1)', $this),
        select = $this.find('.b-xls-form__mode-select'),
        campaignHidden = $this.find('.b-xls-form__campaign-hidden'),
        campaignSelect = $this.find('.b-xls-form__campaign-select'),
        svarsName = $('input[name=svars_name]', optionsForm),
        radioValue = $this.find('.b-xls-form__proc-base-value'),
        radioDiff = $this.find('.b-xls-form__proc-base-diff'),
        model = params.model,
        tables = {
            region: $('.b-xls-form__table-region', $this),
            submit: $('.b-xls-form__table-submit', $this),
            action: $('.b-xls-form__table-action', $this),
            campaign: $('.b-xls-form__table-campaign', $this)
        };
        
    setDisabled({
        region: 1,
        submit: 1,
        action: 1
    });

    onSelectChange();
    model.bind('update', onUpdate);
    model.bind('clear', onClear);
    model.bind('correct_region', onRegionCorrect);
    model.bind('change_camp', onChangeCampaign);

    $('.b-xls-form__geo-selector-link', optionsForm).hide();
    select.change(onSelectChange);

    optionsForm.submit(function() {
        return true;
    });

    function onCampaignChanged(e) {
        setCampaign(this.value * 1)
    }

    function setCampaign(value) {
        model.setCurrentCampaign(value)
    }

    function onChangeCampaign() {
        var camp = model.getCurrentCampaign();
        campaignHidden.val(camp.camp_number);

    }

    function onRegionCorrect() {
        var disabled = model.errors.length && model.errors.length > 0 ? 1 : 0;
        setDisabled({
            action:  disabled,
            region: 0,
            submit: disabled
        });
    }

    function onClear() {
        svarsName.val('');
        tables.campaign.addClass('g-hidden');
        campaignSelect.empty();
        setDisabled({
            action: 1,
            region: 1,
            submit: 1
        });
    }

    function onUpdate() {
        var disabled = {'region': 0, 'submit': 0, 'action': 0};
        svarsName.val(model.svars_name);
        if (model.errors && model.errors.length > 0) {
            disabled = {'region': 1, 'submit': 1, 'action': 1}
        } else if (model.geo_errors && model.geo_errors.length > 0) {
            disabled = {'region': 0, 'submit': 1, 'action': 1}
        }
        builtCampsList();
        setDisabled(disabled)
    }

    function builtCampsList() {
        campaignSelect.empty();
        if (model.campaigns && model.campaigns.length > 1) {
            var select = '<select>';
            $.each(model.campaigns, function(num, camp) {
                select += '<option value="' + camp.camp_number + '">' + camp.camp_name + '</option>'
            })
            select += '</select>';
            select = $(select);
            select.appendTo(campaignSelect);
            select.change(onCampaignChanged);
            tables.campaign.removeClass('g-hidden');
            setCampaign(0);
        } else {
            if (model.campaigns && model.campaigns.length == 1) {
                setCampaign(0);
            }
            tables.campaign.addClass('g-hidden');
        }


    }

    function onSelectChange() {
        var value = select.val();
        $this.removeClass('b-xls-form__pmax b-xls-form__pmin b-xls-form__max b-xls-form__min').addClass('b-xls-form__' + value);
        if (value == 'pmax') {
            radioDiff.css('display', 'none');
            radioValue.prop('checked', true);
        } else {
            radioDiff.css('display', '');
        }

    }


    function setDisabled(map) {
        $.each(map, function(name, disabled){
            if (name == 'region') {
                clearRegion(disabled);
            }
            tables[name][disabled ? 'addClass' : 'removeClass']('b-xls-form__form_disabled');
            $('input', tables[name]).prop('disabled', disabled);
        })
    }

    function clearRegion(disabled) {
        if (disabled) {
             $(document).trigger('external-clear-geo');
        }
        $('.b-xls-form__geo-selector-link', optionsForm)[disabled ? 'hide' : 'show']();
    }
    
};
})(jQuery, window.Lego);
