(function($, Lego) {

Lego.block['b-xls-form__mode_xls'] = function(params) {
    var $this = $(this),
        optionsForm = $('form:eq(1)', $this),
        svarsName = $('input[name=svars_name]', optionsForm),
        model = params.model,
        campLimitError = params.camp_limit_error,
        tables = {
            region: $('.b-xls-form__table-region', $this),
            submit: $('.b-xls-form__table-submit', $this),
            action: $('.b-xls-form__table-action', $this)
        },
        regionInput = $('.b-xls-form__enable-region', optionsForm),
        actionsInputs = {
            'all': $('.b-xls-form__action__input', $this),
            'media': $('.b-xls-form__action__input[value=media]', $this),
            'old': $('.b-xls-form__action__input[value=old]', $this),
            'new': $('.b-xls-form__action__input[value=new]', $this),
            'other': $('.b-xls-form__action__input[value=other]', $this)
        },
        modifyOldCamp = {
            block: $('.b-xls-form__target__old', $this),
            campName: $('.b-xls-form__target-camp', optionsForm),
            campCid: $('.b-xls-form__cid-old', optionsForm)
        },
        split_strategy = {
            block: $('.b-xls-form__split_strategy', $this),
            warning: $('.b-xls-form__split_strategy_warning', $this),
            always_new_banner: $('.b-xls-form__split_strategy-always_new_banner', $this),
            shared_new_banner: $('.b-xls-form__split_strategy-shared_new_banner', $this)
        },
        exists_camp_block = $('.b-xls-form__exists_camp', $this),
        exists_camp_show_phrases = $('.b-xls-form__exists_camp__show-phrases', $this),
        exists_camp = {
            without_any_bids: {
                block: $('.b-xls-form__exists_camp__without_any_bids', $this),
                info: $('.b-xls-form__exists_camp__without_any_bids .b-xls-form__exists_camp__info', $this),
                check: $('.b-xls-form__exists_camp__without_any_bids .b-xls-form__exists_camp__check', $this)
            },
            banners_without_bids: {
                block: $('.b-xls-form__exists_camp__banners_without_bids', $this),
                info: $('.b-xls-form__exists_camp__banners_without_bids .b-xls-form__exists_camp__info', $this)
            },
            lost_banners: {
                block: $('.b-xls-form__exists_camp__lost_banners', $this),
                info: $('.b-xls-form__exists_camp__lost_banners .b-xls-form__exists_camp__info', $this)
            },
            lost_phrases: {
                block: $('.b-xls-form__exists_camp__lost_phrases', $this),
                info: $('.b-xls-form__exists_camp__lost_phrases .b-xls-form__exists_camp__info', $this)
            },
            lost_groups: {
                block: $('.b-xls-form__exists_camp__lost_groups', $this),
                info: $('.b-xls-form__exists_camp__lost_groups .b-xls-form__exists_camp__info', $this)
            },
            changes_minus_words: {
                block: $('.b-xls-form__exists_camp__changes_minus_words', $this),
                info: $('.b-xls-form__exists_camp__changes_minus_words .b-xls-form__exists_camp__info', $this)
            },
            different_currency: {
                block: $('.b-xls-form__exists_camp__different_currency', $this),
                info: $('.b-xls-form__exists_camp__different_currency .b-xls-form__exists_camp__info', $this),
                check: $('.b-xls-form__exists_camp__different_currency .b-xls-form__exists_camp__check', $this)
            }
        };


    setDisabled({
        action: 1,
        region: 1,
        submit: 1
    });

    model.bind('update', onUpdate);
    model.bind('clear', onClear);
    model.bind('correct_region', onRegionCorrect);

    $('.b-xls-form__region', optionsForm).hide();
    regionInput.prop('checked', false);



    var adjustSubmitData = function() {
        var value;
        if (actionsInputs.old.prop('checked')) {
            value = $this.find('.b-xls-form__cid-old').val();
        } else if (actionsInputs.media.prop('checked') || $this.find('.b-xls-form__is-media').val()) {
            value = $this.find('.b-xls-form__cid-media').val();
        } else if (actionsInputs.other.prop('checked')) {
            value = $this.find('.b-xls-form__cid-other').val();
        }
        $this.find('.b-xls-form__cid-hidden').val(value);
        $this.find('.b-xls-form__cmd').val(actionsInputs.media.prop('checked')  || $this.find('.b-xls-form__is-media').val() ? 'importCampToMediaplanXLS' : 'importCampXLS');
    }

    adjustSubmitData();

    optionsForm.submit(function() {
        if (regionInput.prop('checked') && !confirm(Lego.message('b-xls-form:confirm_geo', iget('Выбран ЕДИНЫЙ регион для всех импортируемых объявлений. Вы уверены, что хотите игнорировать настройки региона из XLS файла?')))) return false;
        adjustSubmitData();
        $("input[name=geo]", optionsForm).prop('disabled', !regionInput.prop('checked'));
        return true;
    });


    $('.b-xls-form__destination-camp').change(onDestinationChange);


    regionInput.change(function() {
        if (model.geo_errors.length > 0 && this.checked) {
            model.correctRegion()
        }

        $('.b-xls-form__informer, .b-xls-form__region', optionsForm)[this.checked ? 'show' : 'hide']();
    });

    actionsInputs.all.change(function() {
        var camp = model.getCurrentCampaign(),
            camp_warning = model.parse_warnings_for_exists_camp;

        if ( camp && camp.cid || !camp_warning && $.isEmptyObject(camp_warning)) {
            if (this.value != 'old') {
                exists_camp_block.hide();
                setDisabled({'region': 0, 'submit': 0, 'action': 0});
            } else {
                exists_camp_block.show();
                setDisabled({
                    'region': 0,
                    'submit': camp_warning.without_any_bids &&
                              !exists_camp.without_any_bids.check.prop('checked') ||
                              camp_warning.different_currency &&
                              !exists_camp.different_currency.check.prop('checked')
                             ? 1 : 0,
                    'action': 0
                })
            }
        }
    });

    function onDestinationChange() {
        adjustSubmitData();

        var isMediaChecked = !!actionsInputs.media.prop('checked');

        $this.find('.b-xls-form__moderation-row').toggleClass('g-common__gray', isMediaChecked);
        $this.find('.b-xls-form__change-prices-row').toggleClass('g-common__gray', isMediaChecked);

        //DIRECT-25516
        if (model.parse_warnings_for_exists_camp.without_any_bids) { //DIRECT-27697
            var isNewChecked = !!actionsInputs['new'].prop('checked');
            exists_camp.without_any_bids.block.toggleClass('g-hidden', isNewChecked);
            setDisabled({'submit': isNewChecked ? 0 : !exists_camp.without_any_bids.check.prop('checked')});
        }

        //DIRECT-17960
        window.setTimeout(function() {
            $this.find('input.b-xls-form__dont-change-prices').prop('disabled', isMediaChecked);
            $this.find('input.b-xls-form__send-to-moderation').prop('disabled', isMediaChecked);
        }, 10)

    }

    function onRegionCorrect() {
        var disabled = model.errors.length && model.errors.length > 0 ? 1 : 0;
        setDisabled({
            action:  disabled,
            region: 0,
            submit: disabled
        });
    }

    function updateOldCamp(cid, name) {
        modifyOldCamp.block.toggleClass('g-hidden', !cid);
        if (cid) {
            modifyOldCamp.campName.html('\u2116&nbsp;' + cid + (name ? '&nbsp;' + $('<div/>').text(name).html(): "") );
            modifyOldCamp.campCid.val(cid);
        }
    }

    function onClear() {
        svarsName.val('');
        setDisabled({
            action: 1,
            region: 1,
            submit: 1
        });
        actionsInputs['new'].prop('checked', true);
        split_strategy.warning.toggleClass('g-hidden', !model.has_oversized_banners);
        split_strategy.block.toggleClass('g-hidden', !model.has_oversized_banners);
        for (var i in exists_camp) {
            if (!exists_camp.hasOwnProperty(i)) continue;
            exists_camp[i].info.html('');
            exists_camp[i].block.addClass('g-hidden');
        }
        updateOldCamp(0)
    }

    function onUpdate() {
        var camp = model.getCurrentCampaign(),
            disabled = {'region': 0, 'submit': 0, 'action': 0};

        svarsName.val(model.svars_name);
        if (model.errors && model.errors.length > 0) {
            //если пришли неизвестные ошибки - дисаблим всё
            disabled = {'region': 1, 'submit': 1, 'action': 1}
        } else if (model.geo_errors && model.geo_errors.length > 0) {
            //если только ошибки георегиона - позволяем изменять георегион
            disabled = {'region': 0, 'submit': 1, 'action': 1}
        }

        //предупреждения про пересечения с существующей кампанией
        var camp_warning = model.parse_warnings_for_exists_camp;

        if (camp_warning && !$.isEmptyObject(camp_warning)) {
            if (camp_warning.without_any_bids) {
                disabled = {'region': 0, 'submit': 1, 'action': 0};
                exists_camp.without_any_bids.info.html(camp_warning.without_any_bids);

                actionsInputs['new'].prop('checked') ?
                    setDisabled({'submit': 0}) :
                    exists_camp.without_any_bids.block.removeClass('g-hidden');

                exists_camp.without_any_bids.check.click(function() {
                    setDisabled({'region': 0, 'submit': (this.checked ? 0 : 1), 'action': 0});
                });
            }

            if (camp_warning.banners_without_bids) {
                exists_camp.banners_without_bids.info.html(camp_warning.banners_without_bids);
                exists_camp.banners_without_bids.block.removeClass('g-hidden');
            }
            if (camp_warning.different_currency) {
                disabled = {'region': 0, 'submit': 1, 'action': 0};
                exists_camp.different_currency.info.html(camp_warning.different_currency);
                exists_camp.different_currency.block.removeClass('g-hidden');
                exists_camp.different_currency.check.click(function() {
                    setDisabled({'region': 0, 'submit': (this.checked ? 0 : 1), 'action': 0});
                });
            }
			
			if (camp_warning.lost_banners) {
				var content_bids = [],
					content_bid = camp_warning.lost_banners.replace(/\"|\.$|^\s+|\s+$/g, '').split(':')[1].split(',');
				for (var j = 0;  j < content_bid.length; j++) {
					content_bids.push('<li class="b-xls-form__exists_camp__controls">&ndash;&nbsp;' + content_bid[j] + '</li>');
				}
				exists_camp.lost_banners.info.html(camp_warning.lost_banners.split(':')[0] + ':<ul>' + content_bids.join('') + '</ul>');
				exists_camp.lost_banners.block.removeClass('g-hidden');
			}
			
			if (camp_warning.lost_groups) {
				var content_pids = [],
					content_pid = camp_warning.lost_groups.replace(/\"|\.$|^\s+|\s+$/g, '').split(':')[1].split(',');
				for (var j = 0;  j < content_pid.length; j++) {
					content_pids.push('<li class="b-xls-form__exists_camp__controls">&ndash;&nbsp;' + content_pid[j] + '</li>');
				}
				exists_camp.lost_groups.info.html(camp_warning.lost_groups.split(':')[0] + ':<ul>' + content_pids.join('') + '</ul>');
				exists_camp.lost_groups.block.removeClass('g-hidden');
			}

            if (camp_warning.lost_phrases) {
                var content_phrases = [],
                    content_phrase = camp_warning.lost_phrases.replace(/\"|\.$|^\s+|\s+$/g, '').split(':')[1].split(','),
                    too_many_phrases = '',
                    hellipCutLength = 80;
                for (var i = 0;  i < content_phrase.length; i++) {
                    if (i > 4) {
                        too_many_phrases = ' b-xls-form__exists_camp__controls_hidden';
                        exists_camp_show_phrases.removeClass('g-hidden').click(function() {
                            exists_camp_show_phrases.addClass('g-hidden');
                            $('.b-xls-form__exists_camp__controls_hidden', $this).removeClass('b-xls-form__exists_camp__controls_hidden');
                        });
                    }
                    content_phrases.push('<li class="b-xls-form__exists_camp__controls' + too_many_phrases + '">&ndash;&nbsp;' + direct.utils.hellipCut(content_phrase[i], hellipCutLength) + '</li>');
                }
                exists_camp.lost_phrases.info.html(camp_warning.lost_phrases.split(':')[0] + ':<ul>' + content_phrases.join('') + '</ul>');
                exists_camp.lost_phrases.block.removeClass('g-hidden');
            }
            if (camp_warning.changes_minus_words) {
                exists_camp.changes_minus_words.info.html(camp_warning.changes_minus_words);
                exists_camp.changes_minus_words.block.removeClass('g-hidden');
            }
            if (camp) {
                exists_camp_block.show();
            } else {
                exists_camp_block.hide();
            }
            disabled = {
                'region': 0,
                'submit': camp &&
                          (camp_warning.without_any_bids &&
                          !exists_camp.without_any_bids.check.prop('checked') ||
                          camp_warning.different_currency &&
                          !exists_camp.different_currency.check.prop('checked'))
                         ? 1 : 0,
                'action': 0
            };
        }
        setDisabled(disabled);
        actionsInputs[camp && camp.cid ? 'old' : 'new'].prop('checked', true);
        campLimitError // при достижении лимита количества кампаний, "создать новую" дизаблим, чекед выставляем для "добавить в существующую"
            && actionsInputs['new'].prop('disabled', true)
                && actionsInputs.other.prop('checked', true);
        updateOldCamp(camp.cid, camp.name);
        split_strategy.warning.toggleClass('g-hidden', !model.has_oversized_banners);
        split_strategy.block.toggleClass('g-hidden', !model.has_oversized_banners);
        split_strategy[model.split_strategy == 'always_new_banner' ? 'always_new_banner' : 'shared_new_banner'].prop('checked', true);
        onDestinationChange();
    }




    function setDisabled(map) {
        $.each(map, function(name, disabled){
            if (name == 'region' && disabled) {
                clearRegion();
            }
            tables[name][disabled ? 'addClass' : 'removeClass']('b-xls-form__form_disabled');
            $('input', tables[name]).prop('disabled', !!disabled);
        })
    }

    function clearRegion() {
        $(document).trigger('external-clear-geo');
        $('.b-xls-form__region, .b-xls-form__informer', optionsForm).hide();
        regionInput.prop('checked', false)
    }

};
})(jQuery, window.Lego);
