(function($, Lego) {
Lego.block['b-xls-form__errors'] = function(params) {
    var $this = $(this),
        model = params.model;
    model.bind('update clear correct_region', onChange);

    function hideErrors() {
        $this.hide();
    }

    function onChange() {
        var errors = [].concat(model.errors).concat(model.geo_errors)
        if (errors.length > 0) {
            showErrors(errors);
        } else {
            hideErrors();
        }
    }

    function showErrors (errors) {
        $this
            .html(
                $.map(errors, function(e) {
                    return '<li class="b-xls-form__errors__li">' + $('<div/>').text(e).html() + '</li>';
                }).join('')
            )
            .show();
    }
};
})(jQuery, window.Lego);
