(function($, Lego) {
var loader = Lego.block['b-xls-form__select-file'];
Lego.block['b-xls-form__select-file_mode_xls'] = function(params) {
    var model = params.model;

    function onLoadCallback(data) {
        var errorsPreprocess = [];

        if (!data.errors && !data.geo_errors && !data.svars_name && !data.camp_name) { model.clear(); return; }

        data.errors && data.errors.forEach(function(error) {
            errorsPreprocess = errorsPreprocess.concat(error.split('\n'))
        });
        //сервер иногда не может присылать ошибки нормальным массивом и шлет их строкой
        data.errors = errorsPreprocess;

        var toUpdate = {
            'geo_errors': data.geo_errors,
            'errors': data.errors,
            'svars_name': data.svars_name,
            'campaigns': data.errors &&  data.errors.length > 0 ? [] : [
                {
                    'cid': data.cid,
                    'camp_name': data.camp_name,
                    'parse_warnings': data.warnings
                }
            ],
            'has_oversized_banners': data.has_oversized_banners,
            'parse_warnings_for_exists_camp' : data.errors && data.errors.length > 0 ? {} : {
                'lost_phrases': data.parse_warnings_for_exists_camp.lost_phrases,
                'lost_banners': data.parse_warnings_for_exists_camp.lost_banners,
                'lost_groups': data.parse_warnings_for_exists_camp.lost_groups,
                'changes_minus_words': data.parse_warnings_for_exists_camp.changes_minus_words,
                'without_any_bids': data.parse_warnings_for_exists_camp.without_any_bids,
                'banners_without_bids': data.parse_warnings_for_exists_camp.banners_without_bids,
                'different_currency': data.parse_warnings_for_exists_camp.different_currency
            }
        };
        model.update(toUpdate)

    }

    loader.configure({
        element: this,
        onLoadCallback: onLoadCallback
    })




};
})(jQuery, window.Lego);
