(function($, Lego) {
     var thisBlock = Lego.block['b-xls-form__select-file'] = function(params) {
         var $this,
            file,
            upload,
            cancel,
            loaded,
            preloader,
            onLoadCallback,
            gid         = 1;

         function configure(params) {
             $this = $(params.element);
             file        = $('.b-xls-form__file', $this);
             upload  = $('.b-xls-form__upload', $this).click(onUploadFile);
             cancel = $('.b-xls-form__cancel', $this).click(onCancelFile);
             loaded = $('.b-xls-form__loaded', $this);
             preloader = $('.b-xls-form__loading', $this);
             onLoadCallback = params.onLoadCallback;
             setLoaded(false);
         }

         function onCancelFile() {
            onLoadCallback({});
            setLoading(false);
            setLoaded(false);
         }

         function onUploadFile() {
            if (!file.val()) {
                onLoadCallback({'errors': [Lego.message('b-xls-form:empty_file', iget('Выберите файл'))]});
                return;
            }
            onLoadCallback({});

            setLoading(true);
            $this
                .attr('target', createIframe())
                .submit();
         }

          function createIframe () {
                var target = 'upl_frame_'+ (gid++),
                    iframe = $('<iframe src="javascript:void(0)" name="' + target + '" width="0" height="0" style="display:none;"></iframe>');

                $this.append(iframe);

                iframe.bind('load', function() {
                    fileLoaded(iframe);
                });
                return target;
          }

         function setLoaded (state) {
            file.prop('disabled', state)
                .add(upload)
                .toggle(!state);

            cancel.add(loaded).toggleClass('g-hidden', !state);
            if (state) loaded.html(file.val().replace(/.*[\/\\]/, ''));
         }



        function setLoading (state) {
            file.add(upload).toggle(!state);
            preloader.add(cancel).toggleClass('g-hidden', !state);
        }

        function fileLoaded (iframe) {
            setLoading(false);
            setLoaded(true);
            onLoadCallback(iframe[0].contentWindow.pre_import_camp_xls_result);
        }
        return {
            configure: configure
        };
    }();

})(jQuery, window.Lego);
