(function($, Lego) {
    Lego.block['b-xls-form__warnings'] = function(params) {
        var $this = $(this),
            model = params.model;
        model.bind('update change_camp', onChange);
        model.bind('clear', hideWarnings);

        function hideWarnings() {
            $this.hide();
        }

        function onChange() {
            var warnings = model.getCurrentWarning();
            if (warnings.length > 0) {
                showWarnings(warnings);
            } else {
                hideWarnings();
            }
        }

        function showWarnings(warnings) {
            $this
                .html(
                    $.map(warnings, function(e) {
                        return '<li class="b-xls-form__errors__li">' + $('<div/>').text(e).html() + '</li>';
                    }).join('')
                )
                .show();
        }
    };
})(jQuery, window.Lego);

