;(function(){

    var _ajaxSettings,
        _captchaId;

    // Глобальный обработчик ошибок ajax-запросов для отлова каптч
    $(document).ajaxError(function(e, jqxhr, settings) {
        var data;

        try {
            data = $.parseJSON(jqxhr.responseText);
        } catch (e) {}

        if (jqxhr.status == 429) {
            _ajaxSettings = settings;

            // десерилизуем отправленные данные
            _ajaxSettings.data = BEM.blocks['i-utils'].parseUrl(
                '?' + decodeURIComponent(settings.data).replace(/\+/g, ' ')).query;

            _captchaId = data.captcha_id;

            BEM.create('i-ajax-captcha', { imgUrl: data.captcha_url });
        }
    });

    BEM.decl('i-ajax-captcha', {
        onSetMod: {
            js: function() {
                $('body').append(BEM.HTML.build({
                    block: 'b-ajax-captcha',
                    imgUrl: this.params.imgUrl
                }));

                var _this = this,
                    bCaptcha = _this._bCaptcha = $('.b-ajax-captcha').bem('b-ajax-captcha'),
                    popup = _this._popupa = bCaptcha.findBlockInside('b-popupa'),
                    input = popup && popup.findBlockInside('b-form-input'),
                    isSubmit = false;

                bCaptcha.bindTo('form', 'submit', function() {
                    _this.resend(input.val());
                    isSubmit = true;
                    popup.hide();

                    return false;
                });
                bCaptcha.bindTo('reload', 'click', function() {
                    _this.reloadImg();

                    return false;
                });
                popup.on('hide', function() {
                    _this.trigger('hide', { isSubmit: isSubmit });
                    bCaptcha.destruct();
                    _this.destruct();
                });

                popup.show();
                input.elem('input').focus();
            }
        },

        resend: function(captcha_code) {
            _ajaxSettings.url = _ajaxSettings.url.replace(/&?captcha(_code)?(_id)?=[^&]*/g, ''); //удаляем поля капчи из урла
            $.extend(_ajaxSettings.data || (_ajaxSettings.data = {}),  {
                captcha_code: captcha_code,
                captcha_id: _captchaId
            });

            $.ajax(_ajaxSettings);
        },

        reloadImg: function() {
            if (this._reloading) return false;

            var _this = this,
                bCaptcha = _this._bCaptcha,
                reloadLink = bCaptcha.elem('reload'),
                img = bCaptcha.findElem(_this._popupa.domElem, 'img');

            this._reloading = true;
            reloadLink.html(iget('обновляется...'));

            $.ajax({
                url: '/ajax_get_captcha',
                type: 'get',
                dataType: 'json',
                cache: false,
                success: function(response) {
                    var id = response.captcha_id || 0,
                        url = response.captcha_url || '';

                    img.attr('src', url);
                    reloadLink.html(iget('Показать другие цифры'));

                    _captchaId = id;
                    _this._reloading = false;
                }
            });
        }
    });

})();
