
(function($) {
    //в ходе редактирования id фраз могут менятся, на клиенте мы продолжаем использовать старые, но на сервер нужно сообщать новые
    var changedIds = [],
        iModelManager = BEM.blocks['i-models-manager'];

    BEM.decl({'name': 'i-campaign-ajax-edit'}, {}, {
        updateDeleted: function(changes, type) {
            var _this = this;
            $.each(changes, function(bid, bidData) {
                if (bidData.deleted && bidData.deleted.length > 0) {
                    for (var i = 0; i < bidData.deleted.length; i++) {
                        iModelManager.deleteModel(
                            'campaign&banner:' + bid + '&' + type + ':' + _this.getClientPid(bidData.deleted[i]),
                            'b-phrases-list-phrase');
                    }
                }
            })
        },


        updateSuspended: function() {
            if (this.hasSuspended) {
                BEM.channel('ajax-phrase-edit').trigger('set-suspended');
            }
        },

        getServerPid: function(id) {
            var currentId = id;
            $.each(changedIds, function(i, idsBlock) {
                if (idsBlock.client == id) {
                    currentId = idsBlock.server;
                    return false;
                }
            })
            return currentId;
        },

        getClientPid: function(id) {
            var currentId = id;
            $.each(changedIds, function(i, idsBlock) {
                if (idsBlock.server == id) {
                    currentId = idsBlock.client;
                    return false;
                }
            });
            return currentId;
        },

        saveNewPid: function(oldId, newId) {
            var isSet = false;
            $.each(changedIds, function(i, idsBlock) {
                if (idsBlock.client == oldId) {
                    idsBlock.server = newId;
                    isSet = true;
                    return false;
                }
            });
            if (!isSet) {
                changedIds.push({
                    client: oldId,
                    server: newId
                })
            }
        },

        doRetargetingsRequest: function(changes) {
            this.retargetingRequestCompleted = false;

            if ($.isEmptyObject(changes)) {
                this.retargetingRequestCompleted = true;

                return;
            }
            var _this = this,
                campModel = iModelManager.get('campaign', 'b-campaign-view');

            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                data: {
                'cid': campModel.get('cid'),
                'ulogin': campModel.get('ulogin'),
                'cmd': 'ajaxEditBannerRetargeting',
                'json_banner_retargetings': $.stringify(changes)
            },
                dataType: 'json',
                success: function(data) {
                    _this.onRetargetingsSuccess(data);
                },
                error: function(data) {
                    campModel.trigger('error', iget('Не удалось сохранить данные. Пожалуйста, попробуйте позже.'))
                }
            });
        },

        /**
         * Отправляет запрос на сохранение фраз
         * @param {Object} changes
         */
        doPhrasesRequest: function(changes) {
            this.phraseRequestCompleted = false;
            if ($.isEmptyObject(changes)) {
                this.phraseRequestCompleted = true;

                return;
            }

            var campModel = iModelManager.get('campaign', 'b-campaign-view'), _this = this;

            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                data: {
                    'cid': campModel.get('cid'),
                    'ulogin': campModel.get('ulogin'),
                    'cmd': 'ajaxUpdatePhrasesAndPrices',
                    'json_phrases': $.stringify(changes)
                },
                dataType: 'json',
                success: function(data) {
                    _this.onPhrasesSuccess(data);
                },
                error: function(data) {
                    campModel.trigger('error', iget('Не удалось сохранить данные. Пожалуйста, попробуйте позже.'));
                    _this.phraseRequestCompleted = true;
                }
            });
        },

        updateBanner: function(bid, banner_data) {
            iModelManager.eachModel(function(i, model) {
                model.update({
                    'status': banner_data.status,
                    'statusModerate': banner_data.statusModerate,
                    'statusActive': banner_data.statusActive,
                    'pstatusModerate': banner_data.pstatusModerate,
                    'pstatusPostModerate': banner_data.pstatusPostModerate,
                    'statusShow':banner_data.statusShow ,
                    'statusAutobudgetShow': banner_data.statusAutobudgetShow
                })
            }, 'campaign&banner:' + bid, 'b-banners-list-banner');
        },

        isPriceChanged: function(changes, bid, pid) {
            var _this = this,
                isPricesChanged = false;

            if (changes[bid] && changes[bid].edited &&
                changes[bid].edited[pid])  {
                if (changes[bid].edited[pid].price || changes[bid].edited[pid].price_context) {
                    isPricesChanged = true;
                }
            }
            return isPricesChanged ;
        },

        adjustDeletedPhrases: function(phraseData, bid, pid) {
            if (phraseData.dublicate) {
                if (!this.phrasesChanges[bid]) {this.phrasesChanges[bid] = {deleted: []}}
                if (!this.phrasesChanges[bid].deleted) { this.phrasesChanges[bid].deleted = [] }
                this.phrasesChanges[bid].deleted.push(pid);
                return true;
            }
        },

        fixData: function(changes, phraseData, bid, pid, type) {
            var _this = this;

            iModelManager.eachModel(function(i, model) {
                if (changes[bid] && changes[bid].edited && changes[bid].edited[phraseData.id]) {
                    model.update(phraseData, _this);
                }
                model.fixData();
            }, 'campaign&banner:' + bid + '&' + type + ':' + pid, 'b-phrases-list-phrase');
        },

        rollback: function(errors, changes, type) {
            var _this = this;

            $.each(errors, function(bid, text) {
                iModelManager.eachModel(function(i, model) {
                    var pid = _this.getServerPid(model.get('phraseId'));
                    if (changes[bid] && changes[bid].edited && changes[bid].edited[pid]) {
                        model.rollback();
                    }
                }, 'campaign&banner:' + bid + '&' + type + ':*', 'b-phrases-list-phrase');
            });
        },

        onRetargetingsSuccess: function(data) {

            var campModel = iModelManager.get('campaign', 'b-campaign-view'),
                errors = {},
                _this = this;
            _this.retargetingPricesChanged = false;

            _this.retargetingRequestCompleted = true;
            $.each(this.retargetingsChanges, function(bid, data) {
                data.edited && $.each(data.edited, function(pid, phraseData){
                    _this.retargetingPricesChanged = _this.retargetingPricesChanged || _this.isPriceChanged(_this.retargetingsChanges, bid, pid);

                    _this.fixData(_this.retargetingsChanges, phraseData, bid, pid, 'retargeting');
                });
            });
            _this.onSaveEnd()

        },

        onPhrasesSuccess: function(data) {
            var _this = this;

            this.currentCorrections = { unglued: {}, 'stopword-fixated': {} }; // эту структуру приходится повторять
            this.description = {unglued: 'phrase_unglued_suffix', 'stopword-fixated': 'fixation'};
            this.errors = {};
            this.phraseRequestCompleted = true;

            _this.phrasesPricesChanged = false;

            var campModel = iModelManager.get('campaign', 'b-campaign-view');

            $.each(data, function(bid, banner_data) {
                _this.updateBanner(bid, banner_data);

                var phrases = banner_data.phrases;

                if (banner_data.errors) {
                    _this.errors[bid] = banner_data.errors;
                    return true;
                }

                phrases && $.each(phrases, function (serverPid, phraseData) {
                    var pid = _this.getClientPid(serverPid);

                    if (phraseData.new_id) _this.saveNewPid(pid, phraseData.new_id);

                    _this.phrasesPricesChanged = _this.phrasesPricesChanged || _this.isPriceChanged(_this.phrasesChanges, bid, pid);

                    _this.adjustDeletedPhrases(phraseData, bid, pid);

                    phraseData.minus_words = direct.utils.getMinuswordsFromPhrase(phraseData.phrase);
                    phraseData.key_words = direct.utils.getKeywordsFromPhrase(phraseData.phrase);

                    _this.description && $.each(_this.description, function (i, v) {
                        if (phraseData[v]) {
                            if (!_this.currentCorrections[i][bid]) {
                                _this.currentCorrections[i][bid] = {}
                            }


                            _this.currentCorrections[i][bid][pid] = (i == 'unglued') ?
                                {phrase_unglued_suffix: phraseData.phrase_unglued_suffix, phrase: phraseData.key_words} :
                                {fixation:phraseData.fixation, phrase: phraseData.key_words};

                            !_this.phrasesChanges[bid] && (_this.phrasesChanges[bid] = { edited: {}}  );
                            !_this.phrasesChanges[bid].edited && ( _this.phrasesChanges[bid].edited   = {});
                            _this.phrasesChanges[bid].edited[pid] = $.extend(_this.phrasesChanges[bid].edited[pid], _this.currentCorrections[i][bid][pid])





                        }
                    });
                    _this.fixData(_this.phrasesChanges, phraseData, bid, pid, 'phrase');

                });
            });
            this.onSaveEnd();


        },

        onSaveEnd: function() {
            var campModel = iModelManager.get('campaign', 'b-campaign-view');

            if (!this.retargetingRequestCompleted || !this.phraseRequestCompleted) return;

            if (!$.isEmptyObject(this.errors)) {
                this.rollback(this.errors, this.phrasesChanges, 'phrase');
                campModel.trigger('error', this.errors);
                return;

            } else {
                this.updateDeleted(this.phrasesChanges, 'phrase');
                this.updateDeleted(this.retargetingsChanges, 'retargeting');
                this.updateSuspended();
                campModel.trigger('save', {status: 'success', data:  this.currentCorrections, description: this.description});

            }

            if (this.retargetingPricesChanged || this.phrasesPricesChanged) {
                alert(iget("Ваши ставки сохранены.") + '\n' + iget("Активизация изменений может занимать до 60 минут."));
            }
        },

        mergeChanges: function(data1, data2) {
            var result = $.extend({}, data1);

            $.each(data2, function(bid, changes) {
                if (!result[bid]) {
                    result[bid] = changes;
                    return true;
                }
                if (!result[bid].edited && changes.edited) { result[bid].edited  = changes.edited; }
                if (!result[bid].deleted && changes.deleted) { result[bid].deleted  = changes.deleted; }
                if (result[bid].edited && changes.edited) { result[bid].edited = $.extend(true, result[bid].edited, changes.edited)}
                if (result[bid].deleted && changes.deleted) { result[bid].deleted = $.merge(result[bid].deleted, changes.deleted)}
            });

            return result;

        },

        saveRequest: function() {
            this.doPhrasesRequest(this.phrasesChanges);
            this.doRetargetingsRequest(this.retargetingsChanges);

        },

        save: function(onError) {
            this.setChanges();
            this.validate(this.saveRequest, onError || function() {});
        },

        getCorrectionsData: function(code) {
            var data = {};

            $.each(this.currentCorrections[code], function(bid, correctForBid) {
                data[bid] = {};
                $.each(correctForBid, function(pid, corrForPid) {
                    data[bid][pid] = (code ==  'unglued') ? corrForPid.phrase_unglued_suffix : corrForPid.fixation;
                })
            })

            return $.stringify(data)
        },

        correctPhrases: function(code, accepted) {
            var campModel = iModelManager.get('campaign', 'b-campaign-view'),
                _this = this;


            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                data: {
                    'cid': campModel.get('cid'),
                    'is_rejected': +!accepted,
                    'ulogin': campModel.get('ulogin'),
                    'cmd': 'ajaxApplyRejectCorrection',
                    'correction': code,
                    'json_phrases': this.getCorrectionsData(code)
                },
                dataType: 'json',
                success: function(data){
                    data.phrases && $.each(data.phrases, function(bid, banner_data) {

                        $.each(_this.currentCorrections, function(code, correction){
                            $.each(banner_data, function(serverPid, newPid){
                                var clientPid = _this.getClientPid(serverPid),
                                    correctionsForBid = correction[bid];

                                _this.saveNewPid(clientPid, newPid);

                                if (correctionsForBid) {
                                    correctionsForBid[newPid] = correctionsForBid[serverPid];
                                    delete correctionsForBid[serverPid];
                                }
                            })
                        });

                    })
                }
            });
        },


        calcPhraseLength: function(model) {
            return direct.utils.getKeywordsLength(model.get('phrase'));
        },

        validate: function(onSuccess, onError) {
            var _this = this,
                editModelsGroup = iModelManager
                    .getGroup('campaign&banner:*&phrase:*,campaign&banner:*&retargeting:*', 'b-phrases-list-phrase'),
                validated = true, errors = {}, currentValid, phrasesForBannerLength = {}, keyWordsForBanner = {}, priceError;

            editModelsGroup && $.each(editModelsGroup, function(i, model) {
                if (!model.isChanged()) { return true; }
                
                var bannerId = model.get('bannerId');
                    
                currentValid = model.validateModel();
                if (!phrasesForBannerLength[bannerId]) {phrasesForBannerLength[bannerId] = 0}

                if (!model.get('is_retargeting')) {
                    if (!keyWordsForBanner[bannerId]) {keyWordsForBanner[bannerId] = ''}
                    keyWordsForBanner[bannerId] += (keyWordsForBanner[bannerId] ? ' ' : '') + model.get('key_words');
                }


                phrasesForBannerLength[bannerId] +=  _this.calcPhraseLength(model);
                validated = validated && currentValid;
                
                if (!currentValid && !priceError) {
                    priceError = model.getErrorsMessagesForField('price').length ? model.getErrorsMessagesForField('price') : model.getErrorsMessagesForField('price_context');
                    if (!errors[bannerId]) { errors[bannerId] = ''; }
                    errors[bannerId] += (errors[bannerId] ? '\n' : '') + priceError;
                }
            });
            
            $.each(phrasesForBannerLength, function(bid, length) {
                if (length > CAMPAIGN_MINUS_WORDS_LIMIT) {
                    if (!errors[bid]) {
                        errors[bid] = '';
                    }
                    errors[bid] += iget('Превышена допустимая длина ключевых фраз в %s символов', CAMPAIGN_MINUS_WORDS_LIMIT);
                    validated = false;
                    return false;
                }
            });
            if (!validated) {
                iModelManager.get('campaign', 'b-campaign-view').trigger('error', errors);
                return false;
            }

            !$.isEmptyObject(this.phrasesChanges) ?
                this.validateKeyWords(keyWordsForBanner, onSuccess, onError) :
                onSuccess.call(this);

        },

        //проверка на пересечение с едиными минус-словами
        validateKeyWords: function(data, onSuccess, onError) {
            var campModel = iModelManager.get('campaign', 'b-campaign-view'),
                bids = [], keyWordsData = {}, _this = this;

            $.each(data, function(bid, phrases) {
                bids.push(bid);
                keyWordsData['key_words-'+bid] = phrases;
            });

            $.extend(keyWordsData, {
               'cid': campModel.get('cid'),
               'bids': bids.join(','),
               'cmd': 'ajaxCheckBannersMinusWords',
               'ulogin': campModel.get('ulogin')
            });
            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                data: keyWordsData,
                success: function(data) {
                    if (data.ok) {
                        onSuccess.call(_this)
                    } else {
                        if (confirm(data.problem)) {
                            onSuccess.call(_this);
                        } else {
                            onError.call(_this);
                        }
                    }
                },
                error: function() {},
                dataType: 'json'
            });
        },

        placeChanges: function(modelsGroup, type) {
            var _this = this,
                changes = {};
            modelsGroup && $.each(modelsGroup, function(i, model) {
                if (model.isChanged('toServer')) {
                    var bid = model.get('bannerId'),
                        phraseId = _this.getServerPid(model.get('phraseId'));
                    if (!changes[bid]) {
                        changes[bid] = {}
                    }
                    if (model.get('is_suspended') ) {
                        _this.hasSuspended = true;
                    }
                    if (model.get('deleted')) {
                        if (!changes[bid].deleted) { changes[bid].deleted = []; }
                        changes[bid].deleted.push(phraseId);
                    } else {
                        if (!changes[bid].edited) { changes[bid].edited = {}; }
                        changes[bid].edited[phraseId] = _this.filterData(model.getChangedData('toServer'));

                    }
                    //model.fixData();
                }
            });

            return changes;
        },

        setChanges: function() {
            this.hasSuspended = false;

            this.phrasesChanges =
                this.placeChanges(iModelManager.getGroup('campaign&banner:*&phrase:*', 'b-phrases-list-phrase'), 'phrase');


            this.retargetingsChanges =
                this.placeChanges(iModelManager.getGroup('campaign&banner:*&retargeting:*', 'b-phrases-list-phrase'), 'retargeting');

        },

        filterData: function(data) {
            //сервер не принимает true/false как значения автоброкера - только 0 или 1
            if (data.autobroker !== undefined) {
                data.autobroker = +data.autobroker;
            }
            var campModel = iModelManager.get('campaign', 'b-campaign-view');

            if (campModel.get('strategy') == 'different_places' && campModel.get('places_strategy') != 'search') {
                delete(data.price);
                delete(data.autobroker);
            }
            return data;
        }
    });
})(jQuery);

