(function($){

BEM.DOM.decl('i-campaign-tags', {
    onSetMod: {
        'js': function() {
            var params = this.params;

            this.setTags(params.tags);
            this.__self._byCampaignIdCache[params.cid] = this;
            this._untaggedBannersNum = params.untaggedBannersNum;
        }
    },

    // для вывода количества баннеров, не отмеченных метками
    untaggedBannersNum: function(num){
        if (typeof num == 'undefined') return +this._untaggedBannersNum;
        else this._untaggedBannersNum = num;

        return this;
    },

    setTags: function(tags, withSort) {
        withSort && tags.sort(function(a, b){ if (a.value < b.value) return -1; if (a.value > b.value) return 1; return 0; });
        this._tags = tags;
        this.trigger('change');
    },
    getTags: function(asHash) {
        if (asHash){
            var hash = {};
            $.map(this._tags, function(el){ hash[el.value] = { tag_id: el.tag_id, uses_count: el.uses_count } });
            return hash;
        } else return this._tags;
    }
}, {
    _byCampaignIdCache: {},
    getByCampaignId: function(cid){
        return this._byCampaignIdCache[cid];
    }
});

})(jQuery);
