(function() {
    var MIN_AUTOBUDGET,
        MIN_CLICKS,
        MIN_CPC,
        rate,
        currObj,
        curr;

    BEM.decl('i-easy-forecast', {
        onSetMod : {
            'js' : function() {
                curr = direct.ForecastUtils.getCurrency();
                currObj = get_currency(curr);

                MIN_AUTOBUDGET = currObj.MIN_AUTOBUDGET;
                MIN_CPC = currObj.MIN_AUTOBUDGET_AVG_PRICE;

                MIN_CLICKS = currObj.MIN_AUTOBUDGET_CLICKS_BUNDLE;
                MIN_CPC = currObj.MIN_AUTOBUDGET_AVG_PRICE;

                rate = curr == 'YND_FIXED' ? direct.ForecastUtils.getPseudoCurrency().rate : 1;

                this.init(this.params.phrasesStat, this.params.weekdayFactor);
            }

        },

        init: function(phrasesStat, weekdayFactor) {
            this.weekdayFactor = weekdayFactor || 0.15;
            this.phrases = phrasesStat.phrases;
            this.low_ctr_keys  = phrasesStat.low_ctr_keys;
            this.convUnitRate = rate;
            this.dataDistributed = phrasesStat.data_distributed;

            var data = prepare_budgets_by_strategies_p(this.phrases, this.convUnitRate, curr);

            this.transitions = data.transitions;
            this.budgetMiddle = data.budgetMiddle;
            this.budgetLow = data.budgetLow;
            this.budgetHigh = data.budgetHigh;
            this.recomendedBudget = this.budgetMiddle;
            this.clicksForRecBudget = this.money2clicks(this.recomendedBudget);
            this.left_lim  =  Math.max(10*this.convUnitRate, this.budgetLow*0.9);
            // рассчитываем правый край слайдера: бюджет по Лучшим позициям, но не меньше NNN.
            // И еще так, чтобы Рекомендуемый бюджет не попадал в правую треть слайдера (...*3/1.8)
            this.right_lim =  Math.max(20*this.convUnitRate, this.budgetHigh*1.1);
            this.right_lim =  round_budget(Math.max(this.right_lim, this.left_lim+(this.budgetMiddle-this.left_lim)*3/1.8));

            this.clicksR = this.money2clicks(this.right_lim);
            this.clicksL = this.money2clicks(this.left_lim);
            // Выставляем флаг: надежен ли прогноз (если бюджеты/клики маленькие -- ненадежный)
            this.isReliable = this.budgetHigh >= 16*this.convUnitRate && (this.clicksR - this.clicksL >= 20);
            this.maxBudget = data.maxBudget;
            this.disabledPhrases = this.getDisabledPhrases();
            this.setWeekBundleLimitValues();
            return;
        },

        getDisabledPhrases: function() {
            var disabled = {};
            $.each(this.phrases, $.proxy(function(i, phrase) {
                if ($.inArray(phrase['md5'], this.low_ctr_keys) != -1) {
                    disabled[phrase['md5']] = phrase.phrase ;
                }
            }, this));
            return disabled;
        },

        money2clicks: function(budget, opts) {
            if(budget == this.recomendedBudget && !opts && this.clicksForRecBudget){
                return this.clicksForRecBudget;
            }

            return money2clicks_p(budget, opts, this.transitions);
        },

        clicks2money: function(clicks) {
            return clicks2money_p(clicks, this.transitions);
        },


        money2phrases: function(budget) {
            var phrases = new Object;
            var phrases_cnt = 0;
            for (var i=0, l = this.transitions.length; i < l; i++) {
                var transition = this.transitions[i];
                var transitionCost = transition.cost * transition.add_clicks;
                if (transitionCost < budget) {
                    budget -= transitionCost;
                    if (!phrases[transition.md5]) {
                        phrases_cnt++;
                        phrases[transition.md5] = 1;
                    }
                } else {
                    if (!phrases[transition.md5]) {
                        phrases_cnt++;
                        phrases[transition.md5] = 1;
                    }
                    break;
                }
            };
            return phrases_cnt;
        },

        getWeekBundleLimitValues: function() {
            return this.weekBundleLimits;
        },

        setWeekBundleLimitValues: function() {
            this.weekBundleLimits = {};
            this.weekBundleLimits.min = this._getWeekBundleMinValue();
            this.weekBundleLimits.max = this._getWeekBundleMaxValue();
        },

        _getWeekBundleMaxValue: function() {
            var res = this.calcForecastForWeek({
                'type': 'unlim',
                'unlim': 'unlim'
            });
            return res.total;
        },

        _getWeekBundleMinValue: function() {
            var res = this.calcForecastForWeek({
                'type': "cent1",
                'cent1': MIN_CPC
            });
            return res.total;
        },



        getForecastOptions: function() {
            return {
                context: 0,
                context_sum_coef: -1,
                context_price_coef: 1,
                bm_sum_coef: 100
                //DIRECT-15918
//                disabledPhrases: this.disabledPhrases
            };
        },



        calcForecastForWeek: function(restrictions) {
            return calc_advanced_forecast_p({data_distributed: this.dataDistributed}, restrictions, this.getForecastOptions(), curr);
        },

        //clicks - общее кликов, sum - сумма в у.е.
        getPeriodForSum: function(clicks, sum) {

            var res = this.calcForecastForWeek({
                    type: 'cpc',
                    cpc: sum / rate /clicks
                });

            return clicks * 7 / res.total.clicks;
        },

        getClicksForSum: function(sum, period) {
            var res = this.calcForecastForWeek({
                type: 'sum',
                sum: sum / rate * 7 / period  //sumPerWeek
            });

            return res.total.clicks * period / 7;
        },


        //clicks - общее число кликов, period - число недель
        getSumForPeriod: function(clicks, days) {
            var clicksPerWeek = clicks * 7 / days,
                res = this.calcForecastForWeek({
                    type: 'clicks',
                    clicks: clicksPerWeek
                });
            //cpc не может быть меньше MIN_CPC
            if (res.total.cpc < MIN_CPC) {
                return rate * clicks * MIN_CPC;
            }


            return res.total.sum * rate * days / 7;
        },

        getRecomendedBudget: function() {
            return Math.max(this.recomendedBudget, this.getMinBudget());
        },

        getBudgetForStrategy: function(strategy) {
            if(strategy == 'high')
                return Math.max(this.budgetHigh, this.getMinBudget());
            if(strategy == 'middle')
                return Math.max(this.budgetMiddle, this.getMinBudget());
            if(strategy == 'low')
                return Math.max(this.budgetLow, this.getMinBudget());
            return this.getMinBudget();
        },

        getMinBudget: function() {
            return MIN_AUTOBUDGET * this.convUnitRate;
        },

        getMaxBudget: function() {
            return Math.max(this.getMinBudget(), this.maxBudget);
        },

        getPhrases: function() {
            return this.phrases.map(function(phrase) { return phrase.phrase }).sort();
        },




        /**
         * Достаточно ли данных чтобы пользоваться текущим прогнозом
         */
        isValid: function() {
            return this.budgetHigh > this.getMinBudget();
        },

        /**
         * Есть ли фразы по которым строится прогноз
         */
        isEmpty: function() {
            return this.phrases.length == 0;
        }


    });


})();
