// Логирование JS ошибок, подробнее в data3 i-error-logger.md
(function() {

    var limit = 3,
        counter = '34';

    window.onerror = function handler(message, filename, line, column, e) {
        if (JSON && JSON.stringify && limit-- > 0) {
            var result = 1,
                mcUrl,
                nav = window.navigator,
                stack = (e && e.stack) || (message && message.stack),
                fileInfo = filename ? 'filename: ' + filename + ':' + line + ':' + column : 'nofilename',
                tree = [
                    'JS ' + (!filename || /yastatic|yandex/.test(filename) ? 'in' : 'ex') + 'ternal errors',
                    // у некоторых есть точка в конце, у некоторых нет, что бы получались одинаковые сообщения
                    'message: ' + (message ? message.replace && message.replace(/\.$/, '') : message.message),
                    stack ? 'stack: ' + stack : fileInfo,
                    'href: ' + location.href,
                    'refs: ' + (document.referrer || 'norefs')
                ],
                index = tree.length - 1,
                obj;

            // формируем параметры для метрики
            // https://yandex.ru/support/metrika/data/visit-params.xml
            while (index--) {
                obj = {};
                obj[tree[index]] = result;
                result = obj;
            }

            mcUrl = 'https://mc.yandex.ru/watch/' + counter + '/' +
                '?site-info=' + encodeURIComponent(JSON.stringify(result)) +
                '&rnd=' + Math.random();

            if (typeof nav.sendBeacon === 'function') {
                nav.sendBeacon(mcUrl, ' ');
            } else {
                new Image().src = mcUrl;
            }
        }
    };
})();
