(function($) {

var ready = false,
    SRC = '//export.yandex.ru/counters-js.xml?services=45';

function actualCallback (ctx) {
    callback.call(ctx || _this, inboxCounters || {});
}

BEM.DOM.decl('i-get-export-data', {

}, {
    /**
     * Вызывает фукнцию обратного вызова с актуальными параметрами
     * Функция создана по результатам ревью для облегчения будущего рефакторинга
     * inboxCounters - глобальная переменная
     * @param func
     * @param ctx
     * @private
     */
    _callbackFuncCall: function (func, ctx) {
        func.call(ctx || _this, inboxCounters || {})
    },

    /**
     * Статический метод получения данных с export.yandex.ru.
     * Вызывается по мере необходимости. Запрос делается только при первом вызове.
     * Делаем полностью динамическую вставку, так как изменение src для загрузки данных
     * не кроссбраузерно + необходимо куда-то вставлять тег скрипт, что не всегда удобно
     * TODO изменить, когда сделают новую версию экспорта (export.yandex.ru)
     * @static
     * @param {Function} callback Функция принимающая в параметре данные с экспорта
     * @param {Object} [ctx] Контекст вызова callback
     */
    getData: function (callback, ctx) {
        var _this = this;

        if (ready)
            this._callbackFuncCall(callback, ctx);
        else {
            var script = document.createElement('script');

            script.charset="windows-1251";  //пока необходимый аттрибут
            script.src = SRC;

            script.onload = script.onreadystatechange = function () {
                if (!this.readyState || this.readyState == 'loaded' || this.readyState == 'complete') {
                    ready = true;

                    _this._callbackFuncCall(callback, ctx);

                    //снимаем обработчики и удаляем тег
                    script.onload = script.onreadystatechange = null;
                    document.body.removeChild(script);
                }
            };

            document.body.appendChild(script);
        }
    }
})
})(jQuery);
