(function($) {
     BEM.DOM.decl({name:'i-get-goals-ajax'}, {
     }, {

         replacedGoals: [],



         getGoals: function() {
             if (!this.goals) {
                 return [];
             }

             return this.goals;
         },

         isGoalsEmpty: function() {
             if (!this.goals || !this.goals.length) return true;

             return false
         },

         noActiveGoals: function() {
              if (!this.goals || !this.goals.length) return true;

              var isEmpty = true;

              $.each(this.goals, function(i, goal) {
                  if (goal.allow_to_use) {
                      isEmpty = false;
                      return false;
                  }
              });

              return isEmpty;
          },

         getRealId: function(id) {
             if (this.replacedGoals[id]) {
                 return this.getRealId(this.replacedGoals[id])
             } else {
                 return id;
             }
         },

         getGoalById: function(id) {
             var curGoal;
             id = this.getRealId(id);
             $.each(this.goals, function(i, goal) {
                if (goal.goal_id == id) {
                    curGoal = goal;
                    return false;
                }
             });
             return curGoal;
         },

         getNotAllowedGoals: function(filter) {
             return $.map(this.goals, function(goal) {
                 if (!goal.allow_to_use && $.inArray(goal.goal_id, filter) != -1) {
                     return goal;
                 }
             })
         },


         onReplaceGoalsSuccess: function(data) {
             var _this = this, goalsToDelete = [];

             $.each(data, function(i, goals) {
                 goalsToDelete.push(goals.old_goal_id);
                _this.replacedGoals[goals.old_goal_id] = goals.new_goal_id;
             }) ;
             this.goals = $.map(this.goals, function(goal) {
                 if ($.inArray(goal.goal_id, goalsToDelete) == -1) {
                     return goal;
                 }
             })
         },

         replaceGoals: function(replaceGoals, ulogin, onSuccess, onError) {
             var _this = this;
             this.ulogin = ulogin;

             $.ajax({
                 url: '/registered/main.pl',
                 type: 'POST',
                 dataType: 'json',
                 data: {
                     ulogin: ulogin,
                     json_replace_goals: JSON.stringify(replaceGoals),
                     cmd: 'ajaxReplaceGoalsInRetargetings'
                 },
                 success: function(response) {
                    if (response.result == 'ok') {
                        _this.onReplaceGoalsSuccess(replaceGoals);
                        if (typeof onSuccess == 'function') {
                            onSuccess();
                        }
                    } else {
                        if (typeof onError == 'function') {
                            onError(response.error_text)
                        }
                    }
                 },
                 error: function(response) {
                     if (typeof onError == 'function') {
                         onError(iget('Ошибка при замене целей'))
                     }
                 }
             });
         },


         loadGoals: function(callback, ctx, ulogin) {
             var self = this;
             self.ulogin = ulogin;

             $.ajax({
                 url: '/registered/main.pl',
                 type: 'POST',
                 dataType: 'json',
                 data: {
                     ulogin: ulogin,
                     cmd: 'ajaxGetGoalsForRetargeting'
                 },
                 success: function(response) {
                     self.goals = response;
                     self.goals = $.map(self.goals, function(goal) {
                         goal.goal_name = direct.utils.escapeHTML(goal.goal_name);
                         return goal;
                     });
                     self.isGoalsLoading = false;
                     self.isGoalsLoaded = true;
                     callback.call(ctx);
                     window.setTimeout(function() {
                         self.trigger('loaded')
                     }, 10)

                 },
                 error: function(e) {
                     //ничего не делаем
                 }
             });
         }
     })

})(jQuery);
