(function($) {
    var dataForWord = {},
       countCache = {},
       baseForms = {}; // исходные формы слов

    //загрузчик минус слов и уточнение минус-слов
    BEM.DOM.decl({name:'i-minus-words'}, {
        onSetMod : {
            js: function() {
                this.countTimeout = false;
                this.countLoading = false;
                this.baseFormsLoading = false;

                this.word;   // строчка текущего слова
                this.geo;    // строчка с текущим регионом
                this.data  = dataForWord[this.getGeo() + '-' + this.word] = dataForWord[this.getGeo() + '-' + this.word] || { words: [], has_more: true, loaded: false };
            }

        },

        getDataForWord: function(word, geo) {
            return dataForWord[geo + '-' + word]
        },

        loadWords: function(phrase, geo) {
            this.delMod('status');
            this.setMod('status', 'loading');
            var self = this;
            $.ajax({
                data: { cmd: 'ajaxRefineMinusWords', phrase: phrase, geo: geo },
                type: 'POST',
                url: SCRIPT,
                success: function(json) {
                    var currentData = eval('(' + json + ')');
                    self.data.has_more = currentData.has_more;
                    self.data.words = currentData.words;
                    // слова из уточнения зарание в базовой форме
                    $.each(currentData.words, function(i, word) {
                        baseForms['-' + word.word] = baseForms['-' + word.word] || [];
                        baseForms['-' + word.word].push('-' + word.word);
                    });
                    self.data.loaded = true;
                    dataForWord[self.geo + '-' + self.word] = self.data;
                    self.delMod('status');
                    self.trigger('loaded', self.data)
                }
            });
        },

        scheduleUpdateCount: function(word, geo) {
            if (this.countTimeout) clearTimeout(this.countTimeout);

            var cached = countCache[geo + '-' + word];
            if (cached) {
                this.trigger('count', {count: cached, sure: true});
            } else {
                var self = this;
                self.trigger('count', {count: 0, sure: false});
                this.countTimeout = setTimeout(function() {
                    self.updateCount(word, geo)
                }, 5000);
            }
        },

        updateCount: function(word, geo) {
            this.countTimeout = null;
            var self = this;
            if (countCache[geo + '-' + word]) {
                this.scheduleUpdateCount(word, geo);
                return;
            }
            if (this.countLoading) return;
            this.countLoading = true;
            $.ajax({
                url: SCRIPT,
                type: 'post',
                data: {
                   cmd: "ajaxPhraseStat",
                   geo: geo,
                   w1: word
                },
                success: function(c) {
                    self.countLoading = false;
                    countCache[geo + '-' + word] = c;
                    self.scheduleUpdateCount(word, geo);
                }
            });
        },

        loadBaseFormsSchedle: function(rawMinusWords) {
            if (this.baseFormsLoading) return;
            var unknown = [];
            $.each(rawMinusWords, function(i, word) {
                if (!baseForms[word]) unknown.push(word.substr(1));
            });
            if (!unknown.length) return;
            this.loadBaseForms(unknown, this)
        },

        loadBaseForms:  $.debounce(function(unknown, self) {
            self.baseFormsLoading = true;
            $.ajax({
                data: { cmd: 'ajaxNormWords', words: unknown.join(' ') },
                url: SCRIPT,
                type: 'POST',
                success: function(json) {
                    var words = eval('(' + json + ')');
                    $.each(words, function(form, base) {
                        baseForms['-' + form] = (baseForms['-' + form] || []).concat($.map(base || [], function(w) { return '-' + w }));
                    });
                    self.trigger('baseFormLoading', baseForms)
                    self.baseFormsLoading = false;
                }
            });
        }, 5000)
    });




})(jQuery);



