(function($){
    var utils = BEM.blocks['i-utils'];
    //Используется в i-model.js, напрямую не используется
    //правила валидации прописываются в схеме модели в поле validateRules
    /*
        validateRules = {
            fieldId: {
                condition: function() {
                    //условие при котором необходимо валидировать данное поле
                    если condition нет - поле валидируется всегда
                    this - текущая модель
                },
                list: [
                    {
                        id: 'rule1' ключ, под которым ошибка будет храниться в общем хэше
                        name: 'max|min|format|empty|maxlength' //имя валидатора - если он стандартный
                        preprocess: function(value) { можем как-то обработать значение перед валидацией}
                        condition: function() { условие при котором необходимо проверять поле по данному правилу}
                        validator: function() { кастомная функция валидации, если она нужна}
                        text: function() { текст ошибки, если валидация не отработала }
                    },
                    {...}
                ]
            }
        }
    */
    BEM.decl('i-model-validator', {
        onSetMod: {
            'js': function(){
                this._errors = {};
                this._warnings = {};
                this._model = this.params.model;
                this.toClear = [];
                this.toSet = [];
                this.clear = $.debounce(this._clearFunction, 10, this);
                this.setTrigger = $.debounce(this._setTriggerFunction, 10, this);
            }
        },

        _setTriggerFunction: function() {
            this._model.trigger('error-set', {fields: this.toSet});
            this.toSet = [];
        },

        _clearFunction: function() {
            var _this = this;
            $.map(this.toClear, function(name) {
                _this._errors[name] && (delete _this._errors[name]);
                _this._warnings[name] && (delete _this._warnings[name]);
            });

            this._model.trigger('error-clear', {fields: this.toClear});
            this.toClear = [];
        },

        getErrorsMessagesForModel: function(type) {
            var texts = [];

            type = type || 'errors';

            this['_' + type] && $.each(this['_' + type], function(fieldId, data) {
                $.each(data, function(errorId, errorText) {
                    texts.push(errorText)
                });
            });

            return texts;
        },


        getErrorsMessagesForField: function(fieldId, type) {
            type = type || 'errors';
            if (!this['_' + type] || !this['_' + type][fieldId]) return [];

            var texts = [];

            $.each(this['_' + type][fieldId], function(errorId, text) {
                texts.push(text)
            });
            return texts;
        },

        hasErrors: function(fieldId) {
            return this.has('errors', fieldId);
        },

        hasWarnings: function(fieldId) {
            return this.has('warnings', fieldId);
        },

        has: function(type, fieldId) {
            if (fieldId) { return this['_' + type] && !!this['_' + type][fieldId]}
            return !$.isEmptyObject(this['_' + type]);
        },

        get: function(type) {
            return this['_' + type];
        },

        set: function(ctx, fieldId, ruleId, ruleData) {
            var type = ruleData.warning ? 'warnings' : 'errors';
            (this['_' + type][fieldId] || (this['_' + type][fieldId] = {}))[ruleId] = this.__self.getValue.call(this, ruleData.text, ctx);
            this.toSet.push(fieldId);
            this.setTrigger();
        },

        clearField: function(fieldId) {
            this.toClear.push(fieldId);
            this.clear();
        },

        _getModelRules: function() {
            return this.rules || (this.rules = this.__self.getValue.call(this, this._model.validateRules));
        },

        _getFieldRules: function(fieldId) {
            var rules = this._getModelRules();
            return this.__self.getValue.call(this, rules[fieldId]);
        },

        //Валидируем отдельно поле. Если поле зависит от другого поля, то его некорректно валидировать отдельно!
        validateField: function(fieldId) {
            //не чистим хэш с ошибками для данного поля
            //если поле независимое - кэш с ошибками почистился при попытке редактирования
            var rules = this._getFieldRules(fieldId);
            if (rules.condition && !this.__self.getValue.call(this, rules.condition)) {
                return true;
            }  else {
                return this._processRulesList('', fieldId, rules.list)
            }
        },

        setErrorManual: function(fieldId, errorText) {
            this._errors[fieldId] = errorText ? [errorText] : '';
            this.toSet.push(fieldId);
            this.setTrigger();
        },

        clearModelErrors: function() {
            this.toClear = this._model.getFieldsNames();
            this._clearFunction();
        },

        needToValidateField: function(fieldId) {
            var rules = this._getFieldRules(fieldId);
            return !$.isFunction(rules.condition) || rules.condition.call(this._model);
        },



        //валидируем всю модель
        validateModel: function(ctx) {
            var validated = true,
                _this = this,
                rulesBlock = this._getModelRules();

            this.toClear = this._model.getFieldsNames('all');
            this._clearFunction();
            rulesBlock && $.each(rulesBlock, function(fieldId, rules) {
                //не выполнено обязательное условие проверки, проверять не надо
                if (!rules.condition || _this.__self.getValue.call(_this, rules.condition)) {
                    //порядок важен! мы должны отработать checkRules по каждому полю, даже если где-то раньше проверка провалилась
                    validated = _this._processRulesList(ctx, fieldId, rules.list) && validated
                }
            });
            return validated;
        },

        _processRulesList: function(ctx, fieldId, rulesList) {
            if (!rulesList) { return true; }
            var _this = this,
                fieldValue = _this._model.raw(fieldId),
                value,
                valid = true;

            $.map(rulesList, function(ruleData) {
                ruleData = _this.__self.getValue.call(_this, ruleData);
                if ($.isFunction(ruleData.condition) && !ruleData.condition.call(_this._model)) {
                    //не выполнено условие - пропускаем данную проверку
                    return true;
                }

                var ruleId = ruleData.id;

                value =  $.isFunction(ruleData.preprocess) ? ruleData.preprocess.call(_this._model, fieldValue) : fieldValue;

                if (!_this._validateRule(fieldId, value, ruleId, ruleData)) {
                    //если есть ошибки в поле - варнинги для этого поля не показываем
                    if (!ruleData.warning || !_this.hasErrors()) {
                        _this.set(ctx, fieldId, ruleId, ruleData);
                    }
                    if (!ruleData.warning) valid = false;
                }
            });

            return valid;
        },

        _validateRule: function(fieldId, fieldValue, ruleId, ruleData) {
            switch (ruleData.name || ruleId) {
                case 'required':
                    return !this._model.isFieldEmpty(fieldId);
                case 'format':
                    return this._model.isFieldFormated(fieldId);
                case 'max':
                    var max = this.__self.getValue.call(this, ruleData.value);
                    return (!utils.isEmpty(fieldValue) && !isNaN(fieldValue)) ?
                        ruleData.strict ? +fieldValue < max : +fieldValue <= max
                        : true;
                case 'min':
                    var min = this.__self.getValue.call(this, ruleData.value);
                    return (!utils.isEmpty(fieldValue) && !isNaN(fieldValue)) ?
                        ruleData.strict ? +fieldValue > +min : +fieldValue >= +min
                        : true;
                case 'maxlength':
                    if (typeof fieldValue != 'object') { fieldValue = fieldValue+''; }
                    return fieldValue.length <= ruleData.max;
                default:
                    ruleData = this.__self.getValue.call(this, ruleData);
                    if (ruleData.validator) {
                        return ruleData.validator.call(this._model, fieldValue);
                    } else {
                        return true;
                    }
            }
        },

        validateAjax: function(callbackOk, callbackError) {

        }


    }, {
        getValue: function(value, params) {
            return $.isFunction(value) ? value.call(this._model, params) : value;
        }
    });

})(jQuery);
