(function(MODEL) {
    MODEL.FIELD.types.flag = $.inherit(MODEL.FIELD, {
        /**
         * Определяем дефолтные значения для поля
         * @returns {Object}
         * @private
         */
        _initDefaults: function() {
            this._defaults = this.params.defaults || {
                value: this.params['default'] !== undefined ? this.params['default'] : 0
            };

            return this;
        },

        /**
         *
         * @param value - новое значение поля
         * @param source - объект, инициировавший изменения
         * @param isInit - нужно ли помечать текущее состояние как начальное
         * @param [eventName] - событие, инициировавшее изменение
         * @returns {Object}
         */
        set: function(value, source, isInit, eventName) {
            if (this.isEqual(value)) { return this }

            this._value =  this.checkEmpty(value) ? this._defaults.value : +(!!value);

            if (isInit) {
                this._startValue = this.get();
            } else {
                this.trigger('change', {source: source, value: this._value, eventName: eventName});
            }

            return this;
        },

        /**
         * Проверка значения value на пустоту
         * @param value
         * @returns {Boolean}
         */
        checkEmpty: function(value) {
            return BEM.blocks['i-utils'].isEmpty(value) || value === '0';
        }
    });
})(BEM.MODEL);
