(function(MODEL) {
    var formater = BEM.blocks['i-formater'];

    MODEL.FIELD.types.number = $.inherit(MODEL.FIELD, {

        /**
         * Определяем дефолтные значения для поля
         * @returns {Object}
         * @private
         */
        _initDefaults: function() {
            this._max = this.params.max;
            this._precision = this.params.precision !== undefined ? this.params.precision : 2;

            //значения для поля, отображаемые в том случае, если попытались ввести не число (по умолчанию показываем введённое значение)
            this._fails = this.params.fails || {
                value: this.params.failValue,
                view: this.params.failView
            };

            var defaultValue = this.params['default'] !== undefined ? this.params['default'] : 0;
            this._defaults = this.params.defaults || {
                value: defaultValue,
                view: this.params.defaultView !== undefined ? this.params.defaultView : formater.format(defaultValue, {precision: this._precision})
            };

            return this;

        },

        /**
         * Приводит value к заданной точности
         * @param value
         * @returns {Number}
         * @private
         */
        _clearNumber: function(value) {
            if (!isNaN(value) && this._max && this._max < value) { value = this._max; }
            var failValue = this._fails.value !== undefined  ? this._fails.value : value;
            value = formater.clear(value, {fail: failValue, precision: 10});
            this._fail = isNaN(value);
            if (!isNaN(value) && this._max && this._max < value) { value = this._max; }

            return value;
        },

        /**
         * Успешно ли прошло форматирование поля
         * @returns {boolean}
         */
        isFormated: function() {
            return !this._fail;
        },

        /**
         *
         * @param value - новое значение поля
         * @param source - объект, инициировавший изменения
         * @param isInit - нужно ли помечать текущее состояние как начальное
         * @param [eventName] - событие, инициировавшее изменение
         * @returns {Object}
         */
        set: function(value, source, isInit, eventName) {
            if (this.isEqual(value) && !this.checkEmpty(value)) return this;
            if (!this.checkEmpty(value)) {
                value = this._clearNumber(value);
                this._raw = value;
                this._value =  this._fail ? value : +formater.roundFormated(value, {precision: this._precision});
                this._view = this._fail ? this._fails.view !== undefined  ? this._fails.view : value
                    :  formater.format(value, {precision: this._precision, exponent_delimiter: ''});
            } else {
                this._raw =  this._defaults.value;
                this._value =  this._defaults.value;
                this._view =  this._defaults.view;
            }
            if (isInit && Object.prototype.toString.call(isInit) !== '[object String]') {
                this._startValue = this.get();
            } else {
                this.trigger('change', {source: source, value: this._value, eventName: eventName || isInit});
            }

            return this;
        },

        /**
        * Возвращает текущее значение поля
        * params {'raw'|'view'} mode deprecated
        * @returns {Number}
        */
        get: function(mode) {
            return this.isEmpty() ? this._defaults.value : mode == 'raw' ? this._raw : mode == 'view' ? this._view : this._value;
        },

        /**
         * Возвращает текущее значение поля без применённых к нему обработок (для чисел - например без округления)
         * @returns {*}
         */
        raw: function() {
            return this.isEmpty() ? this._defaults.value : this._raw;
        },

        /**
         * Возвращает значение поля, отформатированное для вывода на печать
         * @returns {String}
         */
        view: function() {
            return this.isEmpty() ? this._defaults.view : this._view;
        }

    });

})(BEM.MODEL);
