(function(MODEL) {
    var domainRegExpString = '(?:(?:[a-z0-9][a-z0-9-]*|[а-яё0-9][а-яё0-9-]*)\\.)+([a-z0-9]{2,}|рф|xn--[a-z0-9-]+)';
    var regexps = {
        'email': new RegExp('^\\s*[a-z0-9_\\.\\-\\+]+\\@' + domainRegExpString + '\\.?\\s*$', 'i')
    };

    MODEL.FIELD.types.string = $.inherit(MODEL.FIELD, {
        /**
         * Определяем дефолтные значения для поля
         * @returns {Object}
         * @private
         */
        _initDefaults: function() {
            this._defaults = this.params.defaults || {
                value: this.params['default'] || ''
            }

            return this;
        },

        /**
         * Устанавливает значение поля
         * @param value
         * @param {Object} [opts]
         * @returns {Object}
         */
        set: function(value, opts) {
            if (this.isEqual(value)) return this;

            if (this.params.preprocess)
                value = this.params.preprocess.call(this, value)

            var format = this.params.format, formated;

            if (format && value) {
                formated = value.match($.isPlainObject(format) ? format : regexps[format]);

                this._fail = !formated;
                value = formated ? value : undefined;
            }
            this._value = value ? '' + value : this._defaults.value;

            this.trigger('change', opts || {});

            return this;
        },

        /**
        * Успешно ли прошло форматирование поля
        * @returns {boolean}
        */
        isFormated: function() {
            return !this._fail;
        }
    });
})(BEM.MODEL);
