(function(MODEL) {
    MODEL.FIELD = $.inherit($.observable, {
        __constructor: function(params, type) {
            this.params = params;
            this._initDefaults();
            this._initStartState();
            this._name = params.name;

            this._type = type;
        },

        /**
         * Задаем начальное значение поля
         * @private
         * return {Object}
         */
        _initStartState: function() {
            this._startValue = this.params.value || this._defaultValue;

            return this;
        },

        /**
         * Определяем дефолтные значения для поля
         * @returns {Object}
         * @private
         */
        _initDefaults: function() {
            this._defaults = this.params.defaults || {
                value: this.params['default'],
                view: this.params.defaultView
            };

            return this;
        },

        /**
         *
         * @param value
         * @param {Object} opts
         * @returns {Object}
         */
        initData: function(value, opts) {
            this
                .set(value, opts)
                .fixData();

            return this;
        },

        /**
         * Помечаем текущее состояние поля как начальное
         * @returns {Object}
         */
        fixData: function() {
            this._startValue = this.get();

            return this;
        },

        /**
         * Устанавливает значение поля
         * @param value
         * @param {Object} [opts]
         * @returns {Object}
         */
        set: function(value, opts) {
            if (this.isEqual(value)) return this; //todo: оторвал проверку на !this.checkEmpty(value) ok?

            this._value = this.checkEmpty(value) ? this._defaults.value : value;

            this.trigger('change', opts || {});

            return this;
        },

        /**
         * Возвращает текущее значение поля
         * @returns {*}
         */
        get: function() {
            return this.isEmpty() ? this._defaults.value : this._value;
        },

        /**
         * Равно ли текущее значение поля значению переменной value
         * @param value - значение для сравнения с текущим значением
         * @returns {boolean}
         */
        isEqual: function(value) {
            return value === this.get() || this.isEmpty() && this.checkEmpty(value);
        },

        /**
         * Менялось ли значение поля с момента последней фиксации начального состояния
         * @returns {boolean}
         */
        isChanged: function() {
            return !this.isEqual(this._startValue) && !(this.isEmpty() && this.checkEmpty(this._startValue));
        },

        /**
         * Возвращает начальное значение поля
         * @returns {*}
         */
        getFieldStartValue: function() {
            return this._startValue || this.getDefault();
        },

        /**
         * Возвращает дефолтное значение поля
         * @returns {*}
         */
        getDefault: function() {
            return this._defaults.value;
        },

        /**
         * Успешно ли приведено значение к нужному типу (подробнее см. для полей типа number и string)
         * @returns {boolean}
         */
        isFormated: function() {
            return true;
        },

        /**
         * Проверка значения value на пустоту
         * @param value
         * @returns {boolean}
         */
        checkEmpty: function(value) {
            return BEM.blocks['i-utils'].isEmpty(value); //todo: заинлайнить реализацию сюда, чтобы избавиться от связанности
        },

        /**
         * Возвращает тип данного поля
         * @returns {'number'|'string'|'flag'|''}
         */
        getType: function() {
            return this._type;
        },

        /**
         * Проверяет текущее значение поля на пустоту
         * @returns {boolean}
         */
        isEmpty: function() {
            return this.checkEmpty(this._value);
        },

        /**
         * Возвращает название DOM-элемента, соответствующего данному полю
         * @returns {String}
         * @deprecated
         */
        getElemName: function() {
            return this._elemName || (this._elemName = this._name.replace(/_/g, "-"));
        },

        /**
         * Возвращает текущее значение поля без применённых к нему обработок (для чисел - например без округления)
         * @returns {*}
         */
        raw: function() {
            return this.isEmpty() ? this._defaults.value : this._value;
        },

        /**
         * Возвращает значение поля, отформатированное для вывода на печать
         * @returns {String}
         */
        view: function() {
            return this.isEmpty() ? this._defaults.view : this._value;
        }
    }, {
        init: function(params, type) {
            if (MODEL.FIELD.types[type]) return new MODEL.FIELD.types[type](params, type);

            return new MODEL.FIELD(params, type)
        },

        types: {}
    });


})(BEM.MODEL);
