(function($){
    /**
     *  Математика переноса средств между кампаниями
     */
    BEM.DOM.decl('i-money-transfer', {}, {
        /**
         * Распределяет сумму sum по равномерно по числу кампаний campsNum
         * @param {Number} sum - сумма которую необходимо распределить
         * @param {Number} count - число кампаний
         * @returns {Object}
         */
        equalToCamps: function(sum, count) {
            var value = common.number.round(sum / count, {'roundType': 'floor'}),
                remains = {
                    num: Math.round((sum - value * count) * 100),
                    value: 1/100
                };

            return {value: value, remains: remains};
        },

        /**
         *
         * Распределяет текущую сумму пропорционально расходам на кампании
         * @param {Number} sum - сумма, которую нужно распределить
         * @param {Array} outlayArray - хэш с данными по расходам на кампаниях
         * @return {Object}
         */
        proportionToCamps: function(sum, outlayArray) {
            var result = [], total = 0, adjust = 0, length = 0;

            $.each(outlayArray, function(cid, value) {
                total += value;
            });

            $.each(outlayArray, function(i, value) {
                !!value && length++;
            })
            $.each(outlayArray, function(i, value) {
                if (value == 0) return;

                var prop = total == 0 ? 1 / length :  value / total,
                    res = common.number.round(sum * prop, {'roundType': 'floor'});
                result.push(res);
                adjust += res;
            });

            var remains = {
                num: Math.round((sum - adjust) * 100),
                value: 1/100
            };

            return { value: result, remains: remains };
        }
    });

})(jQuery);
