(function($){
    var DATA = [], ULOGIN;

    BEM.DOM.decl('i-retargeting-conditions', {}, {
        init: function(data, ulogin) {
            DATA = data || {};
            ULOGIN = ulogin;
        },

        getDataLength: function() {
            var length = 0;
            $.each(DATA, function(i) {
                length++;
            });
            return length;
        },

        getName: function(id) {
            return (this.get(id) || {}).condition_name;
        },

        get: function(id) {
            if (DATA[id]) { return DATA[id]; }
            return false;
        },

        sendSaveRequest: function(condition, onSuccess) {
            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                dataType: 'json',
                data: {
                    ulogin: ULOGIN,
                    cmd: 'ajaxSaveRetargetingCond',
                    json_retargeting_condition: $.stringify(condition)
                },
                success: onSuccess,
                error: function() {
                }
            });
        },

        switchCondition: function(idsArray, isSuspended, onSuccess, onError) {
            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                dataType: 'json',
                data: {
                    ulogin: ULOGIN,
                    cmd: 'ajaxSwitchRetargetingOnBanners',
                    ret_cond_id: idsArray.join(','),
                    is_suspended: isSuspended

                },
                success: function(responce) {
                    if (responce.result == 'error') {
                        alert(responce.error_text);
                        return;
                    }
                    if (typeof onSuccess == 'function') {
                        onSuccess();
                    }
                },
                error: function() {
                    if (typeof onError == 'function') {
                        onError();
                    }
                }
            });
        },

        deleteCondition: function(id, onSuccess) {
            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                dataType: 'json',
                data: {
                    ulogin: ULOGIN,
                    cmd: 'ajaxDeleteRetargetingCond',
                    ret_cond_id: id
                },
                success: function(response, onSuccess, onError) {
                    if (response.result == 'ok') {
                        BEM.channel('i-retargeting-conditions').trigger('delete', id);

                        if (typeof onSuccess == 'function') {
                            onSuccess(response);
                        }
                    } else {
                        var text = '';

                        for (var i = 0; i < response.errors.length; i++) {
                            text +=  response.errors[i].ret_cond_id + ': ' + response.errors[i].error_text;
                        }

                        alert(text);

                        if (typeof onError == 'function') {
                            onError(response);
                        }
                    }
                },
                error: function() {
                }
            });
        },

        edit: function(condition, onSuccess, onError) {
            var _this = this;
            this.sendSaveRequest(condition, function(response) {
                if (response.result != 'ok') {
                    if (typeof onError == 'function') {
                        onError(response);
                        return;
                    }
                } else {
                    condition.ret_cond_id = response.ret_cond_id;
                    condition.num = _this.getDataLength() + 1;
                    DATA[condition.ret_cond_id] = condition;
                    BEM.channel('i-retargeting-conditions').trigger('change', condition);
                    if (typeof onSuccess == 'function') {
                        onSuccess(condition);
                    }
                }

            });
        },

        getAll: function() {
            return DATA;
        }
    });

})(jQuery);
