window.rum && (function(cmd, isIndex) {

    BEM.decl('i-rum-timing', {

        onSetMod: {

            js: function() {
                this.data = {};
                this.send();
            }

        },

        /**
         * Формирует и дёргает счётчик.
         */
        send: function() {
            this.getData().then(this.changeThis(function(data) {
                var counterParams = this.buildCounterParams(this.normalizeMetrics(this.buildMetrics(data)));

                counterParams && this._send(counterParams);
            }));
        },

        _send: function(params) {
            document.createElement('IMG').src = [
                this.getClickUrl(),
                this._serializeParams(params),
                '*'
            ].join('/');
        },


        /**
         * Проверяет наличиние необходимых свойств.
         *
         * @returns {Deferred} Промис от массива промисов.
         */
        getData: function() {
            var timing = this._timing = (window.performance || {}).timing;

            if (!timing || !timing.navigationStart)
                return $.Deferred().reject().promise();

            var data = this.data;

            return $.when.apply($, this.getDataList()).pipe(function() {

                return data;
            });
        },

        buildMetrics: function() {
            var timing = this._timing,
                metrics = {
                    '1036': [timing.domainLookupStart, timing.navigationStart],// wait
                    '1037': [timing.domainLookupEnd, timing.domainLookupStart], // dns
                    '1038': [timing.connectEnd, timing.connectStart], // tcp
                    '1039': [timing.responseStart, timing.connectEnd], // ttfb
                    '1040': [timing.responseEnd, timing.responseStart], // html
                    '1040.906': [timing.responseEnd, timing.domainLookupStart] // html-total
                },
                firstPaintTime = this.data.firstPaintTime;

            if (firstPaintTime && firstPaintTime > 0) {
                metrics['1041'] = [firstPaintTime, timing.responseStart]; // ttfp
                metrics['1041.906'] = [firstPaintTime, timing.domainLookupStart]; // ttfp-total
            }

            return metrics;
        },

        /**
         * Нормализует метрики:
         * - считает их
         * - проверяет
         * - если необходимо - откидывает
         *
         * @param {Object} Собираемые метрики.
         * @returns {Object|undefined} Нормализованные метрики или
         *     undefined если одна из метрик невалидна.
         */
        normalizeMetrics: function(metrics) {
            $.each(metrics, function(key, val) {

                if ($.isArray(val)) {

                    if (val[0] <= 0 || val[1] <= 0 || val[0] < val[1])
                        return metrics = undefined;

                    metrics && (metrics[key] = val = val[0] - val[1]);

                }

                if (val < 0) return metrics = undefined;

            });

            return metrics;
        },

        buildCounterParams: function(metrics) {
            if (!metrics) return;

            var params = this.getCounterParams();

            params.vars = $.extend(metrics, this.params.vars);
            params.vars['1042'] = encodeURIComponent(navigator.userAgent); // ua

            return params;
        },

        /**
         * Возвращает список ожидания.
         *
         * @returns {Array} Массив промисов.
         */
        getDataList: function() {
            if (this.isPrerender()) return [];

            var object,
                property;

            if (this._timing && typeof this._timing.msFirstPaint !== 'undefined') {
                object = this._timing;
                property = 'msFirstPaint';
            }

            this.withLoadTimes(function(loadTimes) {
                object = loadTimes;
                property = 'firstPaintTime';
            });

            var that = this,
                promises = [];

            object && promises.push(
                this.promiseProperty(object, property)
                    .then(function(firstPaintTime) {
                        that.data.firstPaintTime = Math.floor(firstPaintTime * 1000)
                    }));

            return promises;
        },

        /**
         * Возвращает промис на изменение свойства объекта.
         * Если объект или требуемое свойство не существует,
         * промис реджектится.
         *
         * @param {Object} object
         * @param {String} property
         * @returns {Deferred}
         */
        promiseProperty: function(object, property, validator) {
            var sys = this.channel('sys'),
                defer = $.Deferred(),
                onTick = function() {

                    // NOTE: Объект который возвращает loadTimes не изменяемый,
                    // так что отследить изменение его свойств не представляется
                    // возможным. Костыль не красивый, но как сделать иначе я не знаю.
                    var obj = $.isFunction(object) ? object() : object;

                    if (!obj || typeof obj[property] === 'undefined')
                        return defer.reject('Property does not exist');

                    if (validator ? validator(obj[property]) : obj[property] > 0)
                        defer.resolve(obj[property], obj)
                };

            sys.on('tick', onTick);

            defer.always(function() {
                sys.un('tick', onTick);
            });

            return defer.promise();
        },

        withLoadTimes: function(callback) {
            var loadTimes = (window.chrome || {}).loadTimes;

            $.isFunction(loadTimes) && callback && callback.call(this, loadTimes);

            return this;
        },

        /**
         * Возвращает параметры счётчика по-умолчанию.
         *
         * @returns {Object} Дефолтные параметры
         */
        getCounterParams: function() {

            return {
                dtype: 'stred',
                pid: 1,
                cid: 72202,
                path: '690.1033' // => /tech/timing'
            }
        },

        /**
         * Проверяет, находится ли документ в состоянии prerender.
         *
         * @returns {Boolean}
         */
        isPrerender: function() {

            return (document.visibilityState || document.webkitVisibilityState ||
                document.msVisibilityState) === 'prerender';
        },

        getClickUrl: function() {
            var clickHost = this.params.clckHost;

            if (!clickHost) {
                // Если домена нет в параметрах, проверяется текущий домен.
                var yaHost = location.hostname.match(/^(?:[-\w]+\.)*(yandex(?:.[a-z]+)+)$/i);
                clickHost = (yaHost ? yaHost[1] : 'yandex.ru') + '/clck';
            }

            return '//' + clickHost + '/click';
        },

        /**
         * Преобразовывает объект в массив, используя separator
         * в качестве разделителя ключа и значения.
         *
         * @param {Object} obj
         * @param {String} [separator] Разделитель ключа и значения
         *
         * @returns {Array}
         */
        _flatten: function(obj, separator) {
            var arr = [];

            separator = separator || '=';

            $.each(obj, function(key, val) {
                arr.push(key + separator + val);
            });

            return arr;
        },

        _serializeParams: function(params) {
            var that = this;

            $.each(params, function(key, val) {
                if ($.isPlainObject(val))
                    params[key] = that._flatten(val).join(',');
            });

            return this._flatten(params).join('/');
        }

    });

    var page = isIndex ? 629 : 861;

    cmd === 'showCamp' && (page = 1193);
    cmd === 'showCamps' && (page = 1191);
    (/^showCampMultiEdit|addBannerMultiEdit|gobackMultiEdit|addBannerMultiEdit|bannersMultiEdit$/).test(cmd) &&
    (page = 1192);

    BEM.create('i-rum-timing', {

        vars: {
            '143': '28.155.' + page,
            '287': '213'
        }

    });

})(window.rum.cmd, window.rum.isIndex);
