(function($) {

    var maxSuggestCount = 15;

    BEM.decl('i-suggest-dataprovider', {

        init: function(suggestList) {
            this.list = suggestList;
        },

        get: function(val, onSuccess) {
            if (!val) return;

            var result = [],
                searchStr = $.trim(val.toLowerCase());

            $.map(this.list, function(item) {
                var text = item.toLowerCase(),
                    words = text.split(/\s|-/),
                    isMatched = false;

                if (words.length > 1) words.push(text);

                $.each(words, function(i, v) {
                    if (!v.indexOf(searchStr)) isMatched = true;
                });

                isMatched && result.length <= maxSuggestCount && result.push(item);
            });

            onSuccess(result);
        }

    });
})(jQuery);
