$(function() {
    var logger = window.iTimeLogger;
    if (!logger) return;
    var waitForPoints = [ 'bem-init-time', 'window-loaded' ],
        sendLog = function() {
            $.ajax({
                url: '/log-js/render/' + (logger.params.cmd || 'index') + '/' + logger.params.reqid,
                type: 'post',
                dataType: 'json',
                data: $.stringify(logger.renderData),
                success: function() {
                    logger.renderData = {};
                }
            });
        },
        addPoint = function(point, reduceTime) {
            var index = $.inArray(point, waitForPoints);
            reduceTime = +reduceTime || 0;

            logger.renderData[point] = +new Date - logger.params['js-zero-time'] - reduceTime;
            index >= 0 && waitForPoints.splice(index, 1);
            !waitForPoints.length && sendLog();
        };

    addPoint('dom-ready');

    $(window).load(function() {
        if (window.performance && window.performance.timing) {
            var timing = window.performance.timing;

            if (timing.domainLookupStart && timing.responseEnd)
                logger.renderData['html-receive'] = timing.responseEnd - timing.domainLookupStart;
        }

        addPoint('window-loaded');

        typeof logger.params.onload === 'function' && logger.params.onload();
    });

    $(window).bind('bem-inited', function() {
        addPoint('bem-init-time', logger.renderData['dom-ready']);
    });

    $(window).unload(function() {
        addPoint('unload');
        sendLog();
    });
});
