$.extend(BEM.blocks['i-utils'], {

    /**
     * Приводит переданную строку к валидному массиву минус-слов/фраз
     * @param {String} str - Строка из минус-слов/фраз
     * @return {String}
     * @private
     */
    _minusWordsParseString: function(str) {
        var minusPhrases,
            toArrayRexExp = this.phrasesToArrayRexExp;

        minusPhrases = str
            .replace(toArrayRexExp, ',')
            .split(/,+/g)
            .reduce(function(result, minusPhrase) {
                minusPhrase = minusPhrase.trim();

                if (minusPhrase) {
                    minusPhrase = minusPhrase
                        // заменяем пробелы одним
                        .replace(/(\s+)/g, ' ')

                        // удаляем ---
                        .replace(/(-+)/g, '-')

                        // убираем пробелы справа от !, +, -
                        .replace(/(!|-|\+)\s+/g, function(match) {
                            match = match.replace(/\s/g, '');

                            return match;
                        })

                        // удаляем - в начале, в конце фразы
                        .replace(/(^-|-$)/g, '')

                        // убираем лишние пробелы между []
                        .replace(/\[(\s*.+\s*)\]/g, function(match, l) {
                            return '[' + l.trim() + ']';
                        })

                        // убираем лишние пробелы с двух сторон от "
                        .replace(/\s*"\s*/g, '"')

                        .trim();

                    result.push(minusPhrase);
                }

                return result;
            }, []);

        return minusPhrases;
    },

    /**
     * Регулярное выражение по правилам которого строка минус-фраз разбивается на массив
     * */
    phrasesToArrayRexExp: /((^|\s)-+|-\s|,|\n|\r|\t)/g,

    /**
     * Переводит строку минус-слов/фраз в массив.
     * Если Передать массив, вернет тот же массив без изменений
     * @param {String|Array} value - набор минус слов
     * @return {Array}
     * */
    minusWordsStringToArray: function(value) {
        if (Array.isArray(value)) return value;

        return this._minusWordsParseString(value); // разбивает строку на массив
    },

    /**
     * Переводит массив минус-слов/фраз в строку.
     * Если передать строку, вернет ту же строку без изменений
     * @param {Array} value - массив минус-слов
     * @return {String}
     * */
    normalizeMinusWordsString: function(value) {
        var minusWords = this._minusWordsParseString(value);

        return minusWords.length ? '-' + minusWords.join(' -') : '';
    },

    /**
     * Прогоняет фильтр, проверяет является ли переданное значение пустым
     * @param {Array|String} value
     * @return {Boolean}
     * */
    minusWordsIsEmpty: function(value) {
        return !this._minusWordsParseString([].concat(value).join('')).length;
    }

});
