$.extend(BEM.blocks['i-utils'], {

    formatUrl: function(urlObject) {
        urlObject = urlObject || {};

        var protocol = urlObject.protocol || '',
            host = urlObject.host || '',
            port = urlObject.port || '',
            path = urlObject.path || '/',
            query = urlObject.query || '',
            hash = urlObject.hash || '';

        if (protocol && protocol.search('://') !== protocol.length - 3) protocol = protocol + '://';
        if (port && port.charAt(0) !== ':') port = ':' + port;
        if (path && path.charAt(0) !== '/') path = '/' + path;
        if (hash && hash.charAt(0) !== '#') hash = '#' + hash;

        if (query) {
            if (typeof query === 'object') {
                query = Object.keys(query).map(function(key) {
                    return query[key] != undefined ? key + '=' + query[key] : null;
                }).filter(function(item) { return item != null; }).join('&')
            }
            if (query.charAt(0) !== '?') query = '?' + query;
        }

        return protocol + host + port + path + query + hash;
    },

    parseUrl: function(url) {
        var keys = ['source', 'protocol', 'authority', 'userInfo', 'user', 'password', 'host', 'port', 'relative', 'path', 'directory', 'file', 'query', 'hash'],
            parser = /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/,
            matched = parser.exec(url),
            result = {},
            queryObj = {},
            i = keys.length;

        while (i--) result[keys[i]] = matched[i] || '';

        result.query.replace(/(?:^|&)([^&=]*)=?([^&]*)/g, function (index, key, value) {
            if (value) queryObj[key] = value;
        });

        result.query = queryObj;

        return result;
    },

    getUrl: function(cmd, params) {
        return BEM.blocks['i-utils'].formatUrl({
            path: '/registered/main.pl',
            query: $.extend({}, params, {
                cmd: cmd
            })
        })
    }

});
