$.extend(BEM.blocks['i-utils'], {
    isEmpty: function(str) {
        return str == undefined || !!(str + '').match(/^\s*$/);
    },

    emailRegExp: function() {
        return new RegExp('^\\s*[a-z0-9_\\.\\-\\+]+\\@' + BEM.blocks['i-utils'].domainRegExpString + '\\.?\\s*$', 'i');
    },

    isUrl: function(url) {

        this.hrefRegExp = this.hrefRegExp ||
                (new RegExp('^\\s*(?:http:\/\/)?' + this.domainRegExpString + '(?:\\s*$|\/|:\\d+|\\?|#)', 'i'));

        return url.match(typeof this.hrefRegExp == 'function' ? this.hrefRegExp() : this.hrefRegExp);
    },

    domainRegExpString: '(?:(?:[a-z0-9][a-z0-9-]*|[а-яё0-9][а-яё0-9-]*)\\.)+([a-z0-9]{2,}|рф|xn--[a-z0-9-]+)',

    escapeHTMLRe:  /[&<>\"\']/g,

    escapeHTMLReplacer: function(c) {
        return '&#' + c.charCodeAt(0) + ';';
    },

    escapeHTML: function(str) {
        str = '' + str;
        return str.replace(this.escapeHTMLRe, this.escapeHTMLReplacer);
    }
});

