BEM.MODEL.decl({model: 'm-client-wallet', scheme: {
    fields: {
        //cумма на едином счете
        'sum': {
            type: 'number',
            'default': ''
        },
        'currency': { type: 'string' },
        'money_warning_value': {
            type: 'number',
            precision: 0,
            'default' : 20
        }
    },
    validateRules: {
        'money_warning_value': {
            'list': [
                { id: 'required', name: 'required', text: iget('Задано неверное значение порога.') },
                { id: 'format', name: 'format', text: iget('Задано неверное значение порога.') },
                {
                    id: 'min', name: 'min', value: 1,
                    text: iget('Задано неверное значение порога.')
                },
                {
                    id: 'max', name: 'max', value: 99,
                    text: iget('Задано неверное значение порога.')
                }
            ]
        },
        'sum': function() {
            var currencyName = this.get('currency'),
                currency = get_currency(currencyName);

            return {
                'list': [
                    { id: 'required', name: 'required', text: iget('Неправильно указана сумма к оплате.') },
                    { id: 'format', name: 'format', text: iget('Неправильно указана сумма к оплате.') },
                    {
                        id: 'min',
                        name: 'min',
                        value: currency.MIN_PAY,
                        text: iget('Сумма к оплате должна быть не менее %s', format_const(currencyName, 'MIN_PAY'))
                    }
                ]
            }
        }
    }}
});
