y5.require(['Direct:Campaigns', 'Direct:ListTable.MassActions'], function() {
    Direct.Campaigns.MassActions = function(element, options) {
        Direct.ListTable.MassActions.apply(this, arguments);
    }

    Direct.Campaigns.MassActions.prototype = new function() {
        var base = Direct.ListTable.MassActions.prototype;
        
        this._parse = function() {
            this.options.emptyText = iget('Выберите кампании');
            this.campaignsInfo = this.options.campaignsInfo;
            this.actionNames = this.options.actionNames;
            base._parse.apply(this, arguments);
        };
        
        this._getAvailableActions = function(selectedItem) {
            return this.campaignsInfo[selectedItem].actions;
        };
        
        this._getActionName = function(action) {
            return this.actionNames[action];
        };
        
        this._notifyItemsWithoutAction = function(withoutAction) {
            var campaigns = [], camp;
            for (var i=0; i < withoutAction.length; i++) {
                camp = this.campaignsInfo[withoutAction[i]];
                campaigns[i] = camp.name + ' (' + String.fromCharCode(8470) + ' ' + camp.cid + ')';
            };
            var text = iget('Выбранное действие недоступно для кампаний: ') + campaigns.join(', ');
                text += "\n" + iget("Продолжить?");
            return confirm(text);
        };
        
        this._checkBeforeSubmit = function(action, withAction) {
            if (action == 'delCamp' && !confirm(iget('Вы уверены, что хотите удалить выбранные кампании?'))) return false;
            if (action == 'resumeContext' && !confirm(iget('В указанных кампаниях в ближайшее время будут восстановлены показы на тематических площадках по фразам, отключенным за низкий CTR.'))) return false;
            return true;
        };
        
        this._submitForm = function(action, withAction) {
            var form = y5.Elements.create('form', {
                    action: location.href.replace(/\?.*/, ''), 
                    method: action == 'showCampStat' ? 'GET' : 'POST'
                }),
                cmd = y5.Elements.create('input', {type: 'hidden', name: 'cmd', value: action}),
                i, input;
                
            form.appendChild(cmd);
            for (i=0; i < withAction.length; i++) {
                appendInput(form, 'cid', this.campaignsInfo[withAction[i]].cid);
            };
            if (action == 'showCampStat') {
                appendInput(form, 'stat_type', 'campdate');
            }
            if (this.options.ulogin) {
                appendInput(form, 'ulogin', this.options.ulogin);
            }
            if (window.csrf_token) {
                appendInput(form, 'csrf_token', window.csrf_token);
            }
            y5.Dom.getBody().appendChild(form);
            form.submit();
        };
        
        function appendInput(form, name, value) {
            var input = y5.Elements.create('input', {type: 'hidden', name: name, value: value});
            form.appendChild(input);
        }
        
    }

    y5.Utils.objectExtends(Direct.Campaigns.MassActions, Direct.ListTable.MassActions, 'BaseMassActions');
    
    y5.loaded("Direct:Campaigns.MassActions");
})
