y5.require(['Direct:ClientList', 'Direct:ListTable.MassActions'], function() {
    Direct.ClientList.MassActions = function(element, options) {
        Direct.ListTable.MassActions.apply(this, arguments);
    }

    Direct.ClientList.MassActions.prototype = new function() {
        var base = Direct.ListTable.MassActions.prototype;
        
        this._parse = function() {
            this.options.emptyText = iget('Выберите клиентов');
            this.clientInfo = this.options.clientInfo;
            this.actionNames = this.options.actionNames;
            base._parse.apply(this, arguments);
        };
        
        this._getAvailableActions = function(selectedItem) {
            return this.clientInfo[selectedItem].actions;
        };
        
        this._getActionName = function(action) {
            return this.actionNames[action];
        };
        
        this._notifyToMannnyActions = function(withAction) {
            if (withAction.length > 100) {
                alert(iget('Нельзя выполнить действие более чем со 100 клиентами.'));
                return false;
            }
            return true;
        };
        
        
        this._notifyItemsWithoutAction = function(withoutAction) {
            var items = [], item;
            for (var i=0; i < withoutAction.length; i++) {
                item = this.clientInfo[withoutAction[i]];
                items[i] = item.login;
            };
            var text = iget('Выбранное действие недоступно для клиентов: ') + items.join(', ');
                text += "\n" + iget("Продолжить?");
            return confirm(text);
        };
        
        this._submitForm = function(action, withAction) {
            var form = y5.Elements.create('form', {
                    action: location.href.replace(/\?.*/, ''), 
                    method: 'GET'
                }),
                cmd = y5.Elements.create('input', {type: 'hidden', name: 'cmd', value: action}),
                i, input;
                
            form.appendChild(cmd);
            for (i=0; i < withAction.length; i++) {
                appendInput(form, 'client_login', this.clientInfo[withAction[i]].login);
            };
            if (this.options.ulogin) {
                appendInput(form, 'ulogin', this.options.ulogin);
            }
            if (action == 'showSubClientCamps') {
                appendInput(form, 'stat_type', 'by_agency_clients');
            }
            if (action == 'showCampStat') {
                appendInput(form, 'stat_type', this.options.statType);
            }
            if (action == 'archiveUser' || action == 'unArchiveUser') {
                appendInput(form, 'cl_cnt', this.clientInfo.length - withAction.length); // кол-во клиентов которые остались (для редиректа)
                if (window.Direct_cmd)
                    appendInput(form, 'rcmd', window.Direct_cmd);
                if (this.options.agencyClientList)
                    appendInput(form, 'agency_client_list', this.options.agencyClientList);
            }
            if (window.csrf_token) {
                appendInput(form, 'csrf_token', window.csrf_token);
            }
            y5.Dom.getBody().appendChild(form);
            form.submit();
        };
        
        function appendInput(form, name, value) {
            var input = y5.Elements.create('input', {type: 'hidden', name: name, value: value});
            form.appendChild(input);
        }
        
    }

    y5.Utils.objectExtends(Direct.ClientList.MassActions, Direct.ListTable.MassActions, 'BaseMassActions');
    
    y5.loaded("Direct:ClientList.MassActions");
})
