y5.require(['y5:Widget', 'y5:Widget.Window', 'Direct:ListTable'], function() {
    Direct.ListTable.Descriptions = function(element, options) {
        this.element = element;
        this.container = options.container;
        this.options = options;
        
        this.init();
    }

    Direct.ListTable.Descriptions.prototype = new function() {
        this.init = function() {
            this.Toggles = y5.Dom.getDescendants(this.container, 'span', 'Item-Description');
            for (var i=0; i < this.Toggles.length; i++) {
                y5.Events.observe('click', onToggleClick, this.Toggles[i], true, this);
                this.Toggles[i]
            };
            y5.Events.observe(':SearchStart', function() {
                if (this.currentToggle) close.call(this, this.currentToggle);
            }, this.container, true, this);
        }
        
        function onToggleClick(e) {
            var toggle = y5.Dom.getAncestorOrSelf(e.target, 'span', 'Item-Description');
            if (this.currentToggle == toggle) {
                close.call(this, toggle);
            } else {
                open.call(this, toggle)
            }
        }
        
        function close(toggle) {
            if (this.saving) return;
            
            var widget = getWidget.call(this);
            y5.Classes.add(widget.window, 'hidden');
            this.currentToggle = null;
        }
        
        function open(toggle) {
            this.currentToggle = toggle;
            var widget = getWidget.call(this),
                params = toggle.onclick();
            y5.Classes.remove(widget.window, 'hidden');
            widget.params.element = toggle;
            widget.params.halign = params.halign || '0';
            widget.setPosition();
            widget.window.style.marginLeft = params.left || '0';
            this.Textarea.value = params.text;
        }
        
        function save(toggle) {
            this.saving = true;
            setControlsDisabled.call(this, true);
            
            var data = this.currentToggle.onclick(),
                text = this.Textarea.value,
                options = {
                    "cmd": this.options.cmd, 
                    "description": text
                },
                _this = this;
                
            options[data.idfield || 'id'] = data.id;
                
            if (this.options.ulogin) options.ulogin = this.options.ulogin;
            if (this.options.agencyClientList) options.agency_client_list = this.options.agencyClientList;
            if (this.options.agencyLogin) options.agency_login = this.options.agencyLogin;
            
            var request = new y5.Request.XML('/registered/main.pl', {
                method: "POST",
                onload: function(response) {
                    onSaveComplete.call(_this, response, text);
                },
                onerror: function() {
                    onSaveError.call(_this);
                }
            });

            request.send(options)
        }
        
        function setControlsDisabled (state) {
            this.Save.disabled = this.Cancel.disabled = this.Textarea.disabled = state;
        }
        
        function onSaveError() {
            setControlsDisabled.call(this, false);
            this.saving = false;
            alert(iget('Ошибка при сохранении примечаний. Попробуйте еще раз.'))
        }
        
        function notifyOfTitleChange (toggle, text) {
            for (var i=0; i < this.Toggles.length; i++) {
                if (this.Toggles[i] == toggle) break;
            };
            y5.Events.notify(':DescriptionChange', this.container, true, {position: i, text: text});
            if (this.options.model) this.options.model.items[i].setDescription(text);
        }
        
        function onSaveComplete(response, text) {
            if (response.responseText != '1') {
                onSaveError.call(this);
                return;
            }
            setControlsDisabled.call(this, false);
            this.saving = false;
            var data = this.currentToggle.onclick();
            data.text = text;
            this.currentToggle.onclick = function() { return data };
            y5.Classes.assign(this.currentToggle, 'disabled', !text.match(/\S/));
            notifyOfTitleChange.call(this, this.currentToggle, text);
            close.call(this);
        }
        
        function onCloseClick() {
            close.call(this, this.currentToggle);
        }
        
        function onSaveClick() {
            save.call(this, this.currentToggle);
        }
        
        function getWidget() {
            if (!y5.Widget.get(this.element)) {
                var cnt = y5.Widget.make(
                    this.element, 
                    'Widget.Window', {
                        modal: false, 
                        html: getFormHtml.call(this), 
                        halign: 'left', 
                        valign: 'bottom'
                    }
                );
                parseForm.call(this, y5.Dom.getDescendant(y5.Widget.get(this.element).container, 'div'));
            }
            return y5.Widget.get(this.element);
        }
        
        function parseForm(content) {
            this.Textarea = y5.Dom.getDescendant(content, 'textarea');
            var buttons = y5.Dom.getDescendants(content, 'input');
            this.Save = buttons[0];
            this.Cancel = buttons[1];
            y5.Events.observe('click', onCloseClick, this.Cancel, true, this);
            y5.Events.observe('click', onSaveClick, this.Save, true, this);
        }
        
        function getFormHtml() {
            return '<div class="b-list-table__description"><h3>' + iget('Примечания') + '</h3><textarea></textarea>'
                + '<div class="actions"><input type="button" value="' + iget('Сохранить') + '" /><input type="button" value="' + iget('Отменить') + '" /></div></div>'
        }
    }

    y5.loaded("Direct:ListTable.Descriptions");
})
