y5.require(['Direct:ListTable', 'Direct:Storage'], function() {
    Direct.ListTable.MassActions = function(element, options) {
        this.element = element;
        this.options = options || {};
        this.list = this.options.list;
        this.selected = [];
        this.init();
    }

    Direct.ListTable.MassActions.prototype = new function() {
        this.init = function() {
            this._parse();
            this._observeEvents();
            
            this._setDisabled(true);
            updateActions.call(this, Direct.Storage.retrieve(this.list, 'Selectors.Selected', []));
        }
        
        this._parse = function() {
            this.Submit = y5.Dom.getDescendant(this.element, 'input');
            this.Actions = y5.Dom.getDescendant(this.element, 'select');
        };
        
        this._observeEvents = function() {
            y5.Events.observe(':SelectedChange', updateActions, this.list, true, this);
            y5.Events.observe('click', onSubmit, this.Submit, true, this);
        };
        
        this._setDisabled = function(state) {
            this.Submit.disabled = this.Actions.disabled = state;
            y5.Classes.assign(this.element, 'b-mass-actions_disabled', state);
        };
        
        this._getAvailableActions = function(selectedItem) {
            return [];
        };
        
        this._getActionName = function(action) {
            return '?';
        };
        
        this._notifyItemsWithoutAction = function(withoutAction) {
            return true;
        };
        
        this._checkBeforeSubmit = function(action, withAction) {
            return true;
        };
        
        this._notifyToMannnyActions = function(withAction) {
            return true;
        };
        
        
        this._submitForm = function(action, withAction) {
        };
        
        
        function getEnabledActions (selected) {
            var map = {}, actions = [], itemActions;
            for (var i=0; i < selected.length; i++) {
                itemActions = this._getAvailableActions(selected[i]);
                for (var j=0; j < itemActions.length; j++) {
                    if (!map[itemActions[j]]) {
                        map[itemActions[j]] = true;
                        actions.push(itemActions[j]);
                    }
                };
            };
            return actions;
        }
        
        function parseEventObj (eventObj) {
            if (eventObj.selected) {
                this.selected = $.grep(this.selected, function(v) {
                    if (v >= eventObj.indexes[0] && v <= eventObj.indexes[eventObj.indexes.length - 1]) return false;
                    return true;
                });
                this.selected = this.selected.concat(eventObj.selected);
            } else {
                this.selected = eventObj;
            }
            return this.selected;
        }
        
        function updateActions (eventObj) {
            var selected = parseEventObj.call(this, eventObj),
                enabledActions = getEnabledActions.call(this, selected),
                i;

            this.Actions.innerHTML = '';
            for (i=0; i < enabledActions.length; i++) {
                this.Actions.appendChild(y5.Elements.create(
                    'option', 
                    {value: enabledActions[i]}, 
                    this._getActionName(enabledActions[i])
                ));
            };
            if (!enabledActions.length) {
                this.Actions.appendChild(y5.Elements.create('option', {}, this.options.emptyText || '-----'));
            }
            
            this._setDisabled(!enabledActions.length);
            this.selected = selected;
        }
        
        function onSubmit() {
            var selected = this.selected,
                withAction = [],
                withoutAction = [],
                actions,
                action = this.Actions.value;
                
            for (var i=0; i < selected.length; i++) {
                actions = this._getAvailableActions(selected[i]);
                (actions.indexOf(action) > -1 ? withAction : withoutAction).push(selected[i]);
            };
            
            if (withAction.length > 0) {
                if (withoutAction.length && !this._notifyItemsWithoutAction(withoutAction)) return;
                if (!this._notifyToMannnyActions(withAction)) return;
                if (!this._checkBeforeSubmit(action, withAction)) return;
                this._submitForm(action, withAction);
            }
        }
    }

    y5.loaded("Direct:ListTable.MassActions");
})
