y5.require(['Direct:ListTable', 'Direct:Storage'], function() {
    Direct.ListTable.Selectors = function(element, options) {
        this.element = element;
        this.mainInput = y5.Dom.getDescendant(element, 'input')
        this.list = options.list;
        this.indexes = options.indexes;
        
        this.init();
    }
    
    Direct.ListTable.Selectors.prototype = new function() {
        this.init = function() {
            this.inputs = y5.Dom.getDescendants(this.list, 'input', 'Selectors-Checkbox');
            this.visible = [];
            var selected = [];
            
            y5.Events.observe('click', onMainInputClick, this.mainInput, true, this);
            for (var i=0; i < this.inputs.length; i++) {
                y5.Events.observe('click', onInputClick, this.inputs[i], true, this);
                if (y5.Dom.getAncestor(this.inputs[i], 'tr').style.display != 'none')
                    this.visible.push(i);
                if (this.inputs[i].checked) selected.push(i);
            };
            y5.Events.observe(':SearchStart', onSearchStart, this.list, true, this);
            y5.Events.observe(':SearchFinish', onSearchFinish, this.list, true, this);
            notifySelectedChanged.call(this, selected);
        }
        
        function updateSelected() {
            var allChecked = this.visible.length > 0,
                selected = [];
            for (var i=0; i < this.visible.length; i++) {
                if (!this.inputs[this.visible[i]]) continue;
                if (!this.inputs[this.visible[i]].checked) {
                    allChecked = false;
                } else {
                    selected.push(this.visible[i]);
                }
            };
            this.mainInput.checked = allChecked;
            notifySelectedChanged.call(this, selected);
        }
        
        function notifySelectedChanged(selected) {
            y5.Events.notify(':SelectedChange', this.list, true, selected);
            Direct.Storage.store(this.list, 'Selectors.Selected', selected);
        }
        
        
        function onInputClick() {
            updateSelected.call(this);
        }
        
        function onMainInputClick () {
            var state = this.mainInput.checked;
            for (var i=0; i < this.visible.length; i++) {
                this.inputs[this.visible[i]].checked = state;
            };
            notifySelectedChanged.call(this, state ? this.visible : []);
        }
        
        function onSearchStart() {
            this.mainInput.disabled = true;
        }
        
        function onSearchFinish(params) {
            this.mainInput.disabled = false;
            this.visible = params.visible;
            onInputClick.call(this);
        }
    }

    y5.loaded("Direct:ListTable.Selectors");    
});
