Direct.ManageClients = function(element, options) {
    this.element = element;
    this.options = options || {};
    this.clients = this.options.clients || {};
    this.agencies = this.options.agencies || {};
    this.init();
}

Direct.ManageClients.prototype = new function() {
    this.init = function() {
        this.checkboxes = [];
        Direct.Utils.mergeComponentChildren(this, /ManageClients-(\w+)/, ['input', 'div', 'table', 'select', 'td', 'b'], {'ClientType': 'ClientTypes'});
        y5.Events.observe('y5:allComponentsCreated', onComponentsLoaded, y5.Components, true, this);
    }

    function onComponentsLoaded() {
        for (var i = 0; i < this.ClientTypes.length; i++) {
            y5.Events.observe("click", onTypeChange, this.ClientTypes[i], true, this);
        }
        y5.Events.observe("change", onLimitedAgencyChange, this.LimitedAgencies, true, this);
        this.SubmitButton && y5.Events.observe("click", onSubmitButtonClick, this.SubmitButton, true, this);

        if (!this.ClientsTable) return;

        this.rows = y5.Dom.getDescendants(this.ClientsTable, 'tr', 'user-row');

        onTypeChange.call(this);
        this.selectedAgency = getSelectedAgency.call(this);

        for (var i = 0; i < this.rows.length; i++) {
            var checkbox = y5.Dom.getDescendant(this.rows[i], 'input');
            this.checkboxes.push(checkbox);
            y5.Events.observe("click", function(num) {
                return function(event, target) {
                    onClientClick.apply(this, [event, target, num])
                }
            }(i), checkbox, true, this);
        }
        y5.Events.observe('Direct:SortEnd', onOrderChanged, document, true, this)
        resetSavedStates.call(this);
    }

    function onSubmitButtonClick() {
        var self = this;

        moveClientsToAgency.call(this, function() {
            resetSavedStates.call(self);
            onOrderChanged.call(self);
        });
    }

    function onOrderChanged() {
        var num = 1;
        var rows = y5.Dom.getDescendants(this.ClientsTable, 'tr', 'user-row');

        for (var i = 0; i < rows.length; i++) {
            if (rows[i].style.display != 'none') {
                var num_td = y5.Dom.getDescendant(rows[i], 'td' ,'agency-num');
                num_td.innerHTML = num;
                num++;
            }
        }
    }

    function onClientClick(event, target, num) {
        if (this.savedStates[num] != target.checked) {
            this.changed.push(num);
        } else {
            var index = this.changed.indexOf(num);
            this.changed.splice(index, 1);
        }
        this.SubmitButton.disabled = (this.changed.length == 0);
        y5.Classes.assign(this.rows[num], 'changed', this.savedStates[num] != target.checked);
    }

    function getSavingParamsString() {
        var str = '&agency_login=' + encodeURIComponent(this.selectedAgency);
        var num;

        this.addClientsCount = 0;
        this.removeClientsCount = 0;

        for (var i = 0; i < this.changed.length; i++) {
            num = this.changed[i];
            if (this.checkboxes[num].checked) {
                this.addClientsCount++;
            } else {
                this.removeClientsCount++;    
            }
            str += (this.checkboxes[num].checked) ? '&add_cl_login' : '&rm_cl_login';
            str += '=' + encodeURIComponent(this.checkboxes[num].value);
        }

        return str;
    }

    function removeFromOtherClientsConfirm() {
        var change = [];
        this.removeFromAgency = {};
        for (var i = 0; i < this.changed.length; i++) {
            if (this.checkboxes[this.changed[i]].checked &&
                this.clients[this.changed[i]].limited_agency != this.selectedAgency &&
                this.clients[this.changed[i]].limited_agency) {
                
                if (!this.removeFromAgency[this.clients[this.changed[i]].limited_agency]) {
                    this.removeFromAgency[this.clients[this.changed[i]].limited_agency] = []
                }
                this.removeFromAgency[this.clients[this.changed[i]].limited_agency].push(this.changed[i]);
                change.push(this.changed[i]);
            }
        }
        if (change.length == 0) {
            return;
        }

        var names = '';

        for (var i = 0; i < change.length; i++) {
            names += (i == 0) ? this.clients[change[i]].login : ', ' + this.clients[change[i]].login;
        }

        var message = (change.length == 1) ? iget('Вы точно хотите изменить представителя у клиента') + ' ' : iget('Вы точно хотите изменить представителя у клиентов') + ' ';
        if (!window.confirm(message + names + "?")) {
            for (var i = 0; i < change.length; i++) {
                var index = this.changed.indexOf(change[i]);
                this.changed.splice(index, 1);
                y5.Classes.remove(this.rows[change[i]], 'changed');
                this.checkboxes[change[i]].checked = this.savedStates[change[i]];
            }
            this.removeFromAgency = {};
        }
    }

    function moveClientsToAgency(callbackOk, callbackCancel) {
        removeFromOtherClientsConfirm.call(this);
        this.SubmitButton.disabled = true;
        if (this.changed.length == 0) {
            return;
        }
        var url = 'main.pl?cmd=ajaxMoveClientToAgency' + getSavingParamsString.call(this);
        var req = new y5.Request.XML(url);

        var self = this;
        
        req.onload = function(response) {
            if (response.responseText == '1') {
                resetClientsStatesOk.call(self);
                if (typeof callbackOk == 'function') {
                    callbackOk.call(self)
                }
            } else {
                alert(iget('Сохранить изменения не удалось'));
                resetClientsStatesCancel.call(self);
                if (typeof callbackCancel == 'function') {
                    callbackCancel.call(self)
                }
            }
        }
        req.onexception = function(e) {
            alert(e.message)
        };
        req.send();
    }


    function getSelectedAgency() {
        for (var i = 0; i < this.LimitedAgencies.length; i++) {
            if (this.LimitedAgencies[i].selected) { return this.LimitedAgencies[i].value }
        }
    }

    function restoreAgencyInfo() {
        var agency = this.agencies[this.selectedAgency];
        this.AgencyClients.innerHTML = agency['clients_cnt']
        this.AgencyCamp.innerHTML = countAgencyCamp.call(this, this.selectedAgency);
        this.AgencyMail.innerHTML = '<a href="mailto:' + agency['email'] + '">' + agency['email'] + '</a>';
        this.AgencyPhone.innerHTML = agency['phone']
    }

    function countAgencyCamp(agency) {
        var camp = 0;

        for (var i = 0; i < this.clients.length; i++) {
            if (agency == this.clients[i].limited_agency) {
                camp += this.clients[i].camps_cnt * 1;
            }
        }
        return camp;
    }


    function onLimitedAgencyChange() {
        var onChangeOk = function() {
            this.selectedAgency = getSelectedAgency.call(this);
            resetSavedStates.call(this);
            restoreAgencyInfo.call(this)
            onTypeChange.call(this);
        }

        if (this.changed.length > 0) {
            getSavingParamsString.call(this);

            if (window.confirm(iget("Сохранить изменения списка клиентов представителя") + " " + this.agencies[this.selectedAgency].FIO)) {
                moveClientsToAgency.call(this, onChangeOk)
            } else {
                resetClientsStatesCancel.call(this);
                onChangeOk.call(this)
            }
        } else {
            onChangeOk.call(this);
        }        
    }

    function resetClientsStatesOk() {
        for (var i = 0; i < this.changed.length; i++) {
            var num = this.changed[i];
            this.clients[num].limited_agency = (this.checkboxes[num].checked) ? this.selectedAgency : '';
            var agencyTd = y5.Dom.getDescendant(this.rows[num], 'td', 'agency-login');
            agencyTd.innerHTML = (this.checkboxes[num].checked) ? this.agencies[this.selectedAgency].FIO : '-';
            y5.Classes.remove(this.rows[num], 'changed');
            adjustCheckboxVisibility.call(this, num);
        }

        for (var login in this.removeFromAgency) {
            this.agencies[login].clients_cnt = this.agencies[login].clients_cnt - this.removeFromAgency[login].length;
        }
        this.agencies[this.selectedAgency].clients_cnt = this.agencies[this.selectedAgency].clients_cnt + this.addClientsCount - this.removeClientsCount;
        this.AgencyClients.innerHTML = this.agencies[this.selectedAgency].clients_cnt;
        this.AgencyCamp.innerHTML = countAgencyCamp.call(this, this.selectedAgency);
    }

    function resetClientsStatesCancel() {
        for (var i = 0; i < this.changed.length; i++) {
            var num = this.changed[i];
            y5.Classes.remove(this.rows[num], 'changed');
            this.checkboxes[num].checked = this.savedStates[num];
        }
        this.changed = [];
        resetSelectedAgency.call(this);
    }

    function resetSelectedAgency () {
        for (var i = 0; i < this.LimitedAgencies.options.length; i++) {
            this.LimitedAgencies.options[i].selected = (this.LimitedAgencies.options[i].value == this.selectedAgency);  
        }
    }


    function resetSavedStates() {
        this.changed = [];
        this.savedStates = [];
        for (var i = 0; i < this.clients.length; i++) {
            this.checkboxes[i].checked = (this.clients[i].limited_agency == this.selectedAgency);
            this.savedStates.push(this.checkboxes[i].checked);
        }
    }

    function onTypeChange() {
        if (!this.selectedAgency) {
            this.selectedAgency = getSelectedAgency.call(this);    
        }

        for (var i = 0; i < this.clients.length; i++) {
            adjustCheckboxVisibility.call(this, i);
        }

        onOrderChanged.call(this);
    }

    function adjustCheckboxVisibility(i) {
        var display = false;
        if (this.ClientTypes[0].checked) {
            display = display || !this.clients[i].limited_agency;
        }
        if (this.ClientTypes[1].checked) {
            display = display || this.clients[i].limited_agency && this.clients[i].limited_agency == this.selectedAgency;
        }
        if (this.ClientTypes[2].checked) {
            display = display || this.clients[i].limited_agency && this.clients[i].limited_agency != this.selectedAgency;
        }
        this.rows[i].style.display = (display) ? '' : 'none';
    }
}

y5.require (
    [
        'Direct:Utils'
    ],
    function () {y5.loaded('Direct:ManageClients')}
);
