Direct.SortableTable = function(element, options) {
	this.element = element;
	this.options = options || {};
	
	this.init();
}

Direct.SortableTable.prototype = new function() {
	var sortHeaderRegexp = /(^|.*\s)Sort-header-(\S+)/;
	
	this.init = function() {
		this.sortHeaders = {};
		this.defaultOrders = {};
		this.finders = this.options.finders || {};
		this.valueTagNames = {};
		findSortHeaders.call(this);
		bindEvents.call(this);
	}
	
	function bindEvents() {
		for (var i in this.sortHeaders) {
			if (!this.sortHeaders.hasOwnProperty(i)) continue;
			y5.Events.observe('click', onSortHeaderClick, this.sortHeaders[i], true, this);
		}
	}
	
	function onSortHeaderClick(event) {
		var target = y5.Dom.getAncestorOrSelf(event.target, 'span', sortHeaderRegexp);
		this.sortBy(getFieldName(target));
	}
	
	this.sortBy = function(fieldName) {
		var rows = this.finders[fieldName].call(this, this.valueTagNames[fieldName], fieldName);
		var node = this.sortHeaders[fieldName];
		var sortOrder = y5.Classes.test(node, 'Sort-forward') ? 'forward' : (y5.Classes.test(node, 'Sort-backward') ? 'backward' : '');
		if (!sortOrder) {
			sortOrder = this.defaultOrders[fieldName];
		} else {
			sortOrder = sortOrder == 'forward' ? 'backward' : 'forward';
		}
		clearHeaders.call(this);
		y5.Classes.add(node, 'Sort-' + sortOrder);
		rows.sort(sortComparators[sortOrder]);
		if (rows) {
			var container = rows[0].node.parentNode;
			for (var i=0, l = rows.length; i < l; i++) {
			    if (this.options.oddClass) y5.Classes.assign(rows[i].node, this.options.oddClass,  i & 1);
			    if (this.options.evenClass) y5.Classes.assign(rows[i].node, this.options.evenClass,  !(i & 1));
				container.appendChild(rows[i].node)
			};
		}
        y5.Events.notify('Direct:SortEnd', document, true);
    }
	
	function clearHeaders() {
		for (var i in this.sortHeaders) {
			if (!this.sortHeaders.hasOwnProperty(i)) continue;
			y5.Classes.remove(this.sortHeaders[i], 'Sort-forward Sort-backward');
		}
	}
	
	function findRowsForString(tag, fieldName) {
		return findRowsForFunction.call(this, tag, 'Sort-' + fieldName, function(node){
			return node.innerHTML;
		});
	}
	
	function findRowsForNumber(tag, fieldName) {
		return findRowsForFunction.call(this, tag, 'Sort-' + fieldName, function(node){
			var total = node.innerHTML.replace(/&nbsp;/g, ' ').replace(/\s/g, '').match(/\d+([.,]\d+)?/);
			return total ? parseFloat(total[0].replace(',', '.')) : 0;
		});
	}
	
	function findRowsForFunction(tagName, className, orderFunction) {
		return y5.Dom.getDescendants(this.element, tagName, className).map(function(node) {
			return {
				"node": y5.Dom.getAncestor(node, 'tr'),
				"order": orderFunction(node)
			}
		});
	}
	
	var sortComparators = {
		forward: function (a, b) {
			return a.order > b.order ? 1 : (a.order == b.order ? 0 : -1)
		},
		backward: function(b, a) {
			return a.order > b.order ? 1 : (a.order == b.order ? 0 : -1)
		}
	}
	
	var finders = {
		string: findRowsForString,
		number: findRowsForNumber
	};
	
	function getFieldName(headerNode) {
		return headerNode.className.match(sortHeaderRegexp)[2]
	}
	
	function getElementName(node) {
		return node.className.match(elementsRegexp)[2]
	}
	
	function findSortHeaders() {
		var _this = this;
		y5.Dom.getDescendants(this.element, ['span'], sortHeaderRegexp).map(function(node) {
			var fieldName = getFieldName(node);
			_this.sortHeaders[fieldName] = node;
			_this.defaultOrders[fieldName] = y5.Classes.test(node, 'Sort-default-backward') ? 'backward' : 'forward';
			var finderType = y5.Classes.test(node, 'Sort-type-number') ? 'number' : 'string';
			_this.finders[fieldName] = _this.finders[fieldName] || finders[finderType];
			var match = node.className.match(/Sort-tag-(\w+)/);
			_this.valueTagNames[fieldName] = match ? match[1].split('-') : 'span';
		})
	}
}

y5.loaded("Direct:SortableTable");