include('../jq/common/format.js');
include('../jq/common/inflector.js');

Direct.Utils = new function() {
	function getElementName(node, regexp) {
		var match = node.className.match(regexp);
		return match ? match[1] : '';
	}
	
    this.mergeComponentChildren = function(component, regexp, tagNames, pluralize) {
        this.addOtherParentChildren(component, component.element, regexp, tagNames, pluralize)
    }

    this.addOtherParentChildren = function(component, element, regexp, tagNames, pluralize) {
        pluralize = pluralize || {};
        for (var i in pluralize) {
            if (!pluralize.hasOwnProperty(i)) continue;
            var result = pluralize[i].match(/Hash-(\w+)/);
            if (result) {
                pluralize[i] = result[1]
                component[result[1]] = {};
            } else {
                component[pluralize[i]] = [];
            }
        }
		y5.Dom.getDescendants(element, tagNames, regexp).forEach(function(node) {
		    var name = getElementName(node, regexp);
            if (pluralize[name]) {
                if ((component[pluralize[name]] instanceof Array)) {
                    component[pluralize[name]].push(node)
                } else {
                    var nodeName = node.className.match(/Name-(\w+)/)[1]
                    component[pluralize[name]][nodeName] = node;
                }

		    } else {
		        component[name] = node;
		    }
		});
    }
    
    this.bind = function(fun, object /*, arguments ... */) {
        var args = [];
        for (var i=2, l = arguments.length; i < l; i++) {
            args.push(arguments[i]);
        };
        return function() {
            // arguments это не массив. Поэтому нужны танцы с бунами чтобы его приконкатенировать
            var a = [].concat(args);
            for (var i=0, l = arguments.length; i < l; i++) {
                a.push(arguments[i]);
            };
            fun.apply(object, a);
        }
    }
    
    this.formatNumber = function() {
        return common.format.number.apply(common.format, arguments)
    }

    this.formatHref = function() {
        return common.format.href.apply(common.format, arguments)
    }
    
    this.indexize = function(array, fieldName) {
        var result = {};
        if (fieldName) {
            for (var i=0; i < array.length; i++) {
                result[array[i][fieldName]] = array[i];
            };
        } else {
            for (var i=0; i < array.length; i++) {
                result[array[i]] = true;
            };
        }
        return result;
    }

    this.validateHref = function(href) {
        return href.match(/^\s*(http:\/\/)?([a-zа-я0-9-]+\.)+[a-zа-я]+(\s*$|\/|:\d+|\?|#)/i)
    }
    
    this.extractDomain = function(url) {
		return y5.Strings.trim(url).replace(/http(s)?:\/\//, '').replace(/[\/\?].*/, '').replace(/\#.*/, '').replace(/\/$/, '')
	}
    
    this.pluralize = common.inflector.pluralize;
    this.pluralizeWord = common.inflector.pluralizeWord;
    
    
    // ie only
    this.observeFontSizeChange = function(parent) {
        if (this.fontSizeChangeIframe) return;
        var iframe = document.createElement('iframe'),
            style = iframe.style;
        iframe.frameBorder = 0;
        iframe.src = "javascript:'<body style=\\'overflow:hidden\\' onresize=\\'top.Direct.Utils.notifyFontSizeChanged()\\'>'";
        style.width = '1em';
        style.position = 'absolute';
        style.left = '0';
        style.top = '0';
        parent = parent || y5.Dom.getBody();
        parent.appendChild(iframe);
        this.fontSizeChangeIframe = iframe;
    }
    
    this.notifyFontSizeChanged = function() {
        y5.Events.notify(':fontSizeChanged', document, true);
    }
    
    this.fixIEBgFlickering = function() {
        try {
            document.execCommand('BackgroundImageCache', false, true);
        } catch(e) {}
    }
    
}
y5.loaded('Direct:Utils');
