/**
 * Logs js errors to server via xhr. Works only for browsers with window.onerror (mozilla and ie)
 * This file is self-contained. No other framework is needed 
 */
ErrorLogger = function() { 
}

ErrorLogger.url = '/log-js-errors';


ErrorLogger.prototype = {
	errorsLimit: 3,
	
	log: function(data) {
		var xhr = this._getXHR();
		var content = [];
		for (var i in data) {
			if (!data.hasOwnProperty(i)) continue;
			content.push(i + '=' + encodeURIComponent(data[i]))
		}
		// don't bother about callback
		xhr.open('POST', ErrorLogger.url, true);
		xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded; charset=UTF-8');
		xhr.send(content.join('&'));
	},
	
	register: function() {
		var _this = this;
		window.onerror = function() {
			_this._handleError.apply(_this, arguments)
		}
	},
	
	_handleError: function(message, url, line) {
		if (!this.errorsLimit) return;
		this.errorsLimit--;
		var data = {
			message: message,
			url: url,
			line: line,
			userAgent: navigator.userAgent,
			location: document.location.href,
			cmd: window.Direct_cmd || ''
		}
		this.log(data);
	},
	
	_getXHR: function() {
		var xhrs = [
		function() {return new XMLHttpRequest()},
		function() {return new ActiveXObject('Msxml2.XMLHTTP')},
		function() {return new ActiveXObject('Microsoft.XMLHTTP')}
		];
		for (var i=0, l = xhrs.length; i < l; i++) {
			try {
				return xhrs[i]();
			} catch (e) { }
		};
	}
}

new ErrorLogger().register();