y5.require('Events', init);

function init() {
    y5.Events.create("load", createTips, window, true);

    if(y5.is_ie) {
        try {
            document.execCommand('BackgroundImageCache', false, true);
        } catch(e) {}
    }        
}

function createTips() {
    var container = y5.Dom.getElementByClass("context-ad");

    for(var i = 1; i <= 5; i++) {
        var tip = y5.Dom.getElementByClass("type" + i, container);
        var self = this;
        
        y5.Events.create("mouseover", function(e) {
            e.target.style.cursor = "pointer";        
        }, tip, true);

        y5.Events.create("click", function(e) {
            var target = e.target;

            if(target.className.indexOf("summary") > -1) {
                target = y5.Dom.getElementByClass("image", target.parentNode);
            }    

            if(target.className.indexOf("type") > -1) {
                target = y5.Dom.getElementByClass("image", target);
            }

            self.drawTooltip(target);
        }, tip, true);
    }
}

function drawTooltip(tip) {
    var tooltip = y5.Dom.getElementByClass("promo-tooltip");

    if(!tooltip) {
        tooltip = document.createElement("div");
        document.body.appendChild(tooltip);
        tooltip.className = "promo-tooltip";
    }

    tooltip.style.top = y5.Dom.getOffset(tip)[1] + tip.offsetHeight + y5.Dom.getElementByClass("summary", tip.parentNode).offsetHeight + 5 + "px";
    tooltip.style.left = y5.Dom.getOffset(tip)[0] - 315 + "px";

    tooltip.innerHTML = y5.Dom.getElementByClass("desc", tip.parentNode).innerHTML;

    var closeLink = y5.cssQuery("table td.two img", tooltip)[0];

    y5.Events.create("click", function(e) {
        var tooltip = y5.Dom.getParentByClass("promo-tooltip", e.target);
        tooltip.parentNode.removeChild(tooltip);
        e.preventDefault();
    }, closeLink, true);
}
