(function() {
/**
 * @class Содержит функции для работы с массивами.
 * @static
 * @name y5.Arrays
 * @memberOf y5
 */
y5.Arrays = {
    
    /**
     * Удаляет повторяющиеся значения из массива.
     * @name y5.Arrays.unique
     * @memberOf y5.Arrays
     * @function
     * @param {Array} array Массив
     * @returns {Array} Массив с уникальными значениями
     *
     * @example
     * y5.Arrays.unique([1, '', 'test', 0, 4, 0, '', 5])
     * // -> [1, '', 'test', 0, 4, 5]
     */
    unique: function (array) {
        var newArray = [];
        array.forEach(
            function (element) {
                if (newArray.indexOf(element) == -1) {
                    newArray.push(element);
                }
            }
        );
        return newArray;
    },
    
    /**
     * Удаляет все вхождения значения из массива.
     * @name y5.Arrays.dropValue
     * @memberOf y5.Arrays
     * @function
     * @param {Array} array Массив
     * @param {String} value Значение
     * @returns {Array} Обработанный массив
     *
     * @example
     * y5.Arrays.dropValue([1,2,'',4,5,false,5,8,0,4,5,'test',0,1], false)
     * // -> [1,2,'',4,5,5,8,0,4,5,'test',0,1]
     */
    dropValue: function (array, value) {
        return array.filter(
            function (element) {
                return element !== value;
            }
        ); 
    },
    
    /**
     * Удаляет из массива элемент по индексу.
     * @name y5.Arrays.dropIndex
     * @memberOf y5.Arrays
     * @function
     * @param {Array} array Массив
     * @param {Number} index Индекс
     * @returns {Array} Обработанный массив
     *
     * @example
     * y5.Arrays.dropValue([1,2,3,4,5,5,5,8,3,4,5,0,1], -1)
     * // -> [1,2,3,4,5,5,5,8,3,4,5,0]
     */
    dropIndex: function (array, index) {
        array = this.clone(array);
        array.splice(index, 1);
        return array;
    },
    
    /**
     * Создает копию массива.
     * @name y5.Arrays.clone
     * @memberOf y5.Arrays
     * @function
     * @param {Array} array Массив
     * @returns {Array} Копия массива
     *
     * @example
     * var arr = [1,2,3,4,5,6];
     * var newArr = arr;
     * newArr[1] = 'new value';
     * // arr == [1,'new value',3,4,5,6]
     *
     * var arr = [1,2,3,4,5,6];
     * var newArr = y5.Arrays.clone(arr);
     * newArr[1] = 'new value';
     * // arr == [1,2,3,4,5,6]
     * // newArr == [1,'new value',3,4,5,6]
     */
    clone: function (array) {
        return [].concat(array);
    },
    
    /**
     * Конвертирует объект в массив.
     * @name y5.Arrays.fromObject
     * @memberOf y5.Arrays
     * @function
     * @param {Object} object Объект
     * @returns {Array}
     *
     * @example
     * y5.Arrays.fromObject({2:'value2', test:'var1'});
     * // -> ['value2', 'var1']
     */
    fromObject: function (object) {
        var i,
            newArray = [];
        for (i in object) {
            newArray.push(object[i]);
        }
        return newArray;
    },
    
    /**
     * Возвращает массив без null/undefined элементов.
     * @name y5.Arrays.compact
     * @memberOf y5.Arrays
     * @function
     * @param {Array} array массив
     * @returns {Array}
     * 
     * @example
     * y5.Arrays.compact(['yandex', ,'google', ,'yahoo', null]);
     * // -> ['yandex', 'google', 'yahoo']
     */
    compact: function (array) {
        return array.filter(function(element) {
            return !y5.Types.nul(element) && !y5.Types.undef(element);
        })
    }
};

y5.loaded('Arrays');

})();