/**
 * <strong>Пример</strong>
 * &lt;html&gt;
 *     &lt;head&gt;
 *         &lt;script src="http://img.yandex.net/js/ver/y5.js"&gt;&lt;/script&gt; &lt;!-- подключим ядро --&gt;
 *     &lt;/head&gt;
 *     &lt;body&gt;
 *         &lt;!-- описываем html-часть компонента, в оттрибуте onclick параметры инициализации, описанные ниже --&gt;
 *         &lt;div class="y5-c-Components-AutoComplete" onclick="return params"&gt;
 *             &lt;input class="y5-AutoComplete-Select" /&gt;
 *         &lt;/div&gt;
 *         &lt;script&gt;
 *             function onload(){
 *                 y5.CallBacks.dispatch('srcload'); // инициализируем событие srcload
 *             }
 *             // грузим модули CallBacks и Components с обработчиком загрузки onload
 *             y5.require(['CallBacks', 'Components'], onload);
 *         &lt;/script&gt;
 *         &lt;!-- Важно: что инициализация события srcload должна произойти в самом конце html-страницы, перед закрытием body --&gt;
 *     &lt;/body&gt;
 * &lt;/html&gt;<br/>
 * <strong>Параметры</strong>
 * Eсли данных немного то следует использовать строку с данными
 *     {data: '&lt;o v="1"&gt;value1&lt;/o&gt;&lt;o v="2"&gt;value2&lt;/o&gt;...' }
 * Eсли данных много то следует их сложить в отдельных файл и дать на него ссылку
 *     {link: 'data.xml',  // url на файл с данными, фомат файла смотреть ниже
 *      id: 'reqiestid'   // id запроса для кеширования данных}
 * Файл с данными должен представлять собой обычную выдачу для аяксового запроса через тег &lt;script&gt;
 *     y5.AjaxJS.onload('requestid', '&lt;o v="1"&gt;value1&lt;/o&gt;&lt;o v="2"&gt;value2&lt;/o&gt;...');
 * requestid придет параметром в строке запроса<br/>
 * <strong>Генерируемые события</strong>
 * События генерируются на инпуте
 *     open – в момент раскрытия автокомплита
 *          - без данных
 *     close – в момент закрытия автокомплита
 *          - без данных
 *     change – на изменение
 *          - value – значение поля "v"
 *          - parent – значение поля "p"
 *
 * @alias y5.Components.AutoComplete
 */

y5.Components.AutoComplete = new function(){
    this.className = 'y5-AutoComplete-';
    this.cache = {};
    this.createFromTag = function(element, params){
        var _this = this;
        var input = y5.Dom.getElementByClass(new RegExp(this.className + '\\w+', ''), element);
        if (params.data){
            this.initComponent(input, params.data, params);
            return;
        }
        y5.require(['Ajax', 'AjaxJS'], function(){_this.loadData(element, params, input)});
    };

    this.loadData = function(element, params, input){
        if (!params.link){
            return;
        }

        var cache = this.getCacheRow(params.id);

        if (cache.result == null){
            cache.result = '';
            var ajax = new y5.Ajax(
                new y5.AjaxJS(params.id),
                params.link,
                responseOK,
                y5.NULL
            );
            ajax.send();
        }

        if(cache.result == ''){
            cache.inputs.push(input);
        }else if (cache.result){
            this.initComponent(input, cache.result, params);
        }

        var _this = this;
        function responseOK(result){
            cache.result = result;
            for (var i = 0, l = cache.inputs.length; i < l; i++){
                _this.initComponent(cache.inputs[i], result, params);
            }
            cache.inputs = [];
        };
    };
    this.getCacheRow = function(id){
        if (!this.cache[id]){
            this.cache[id] = {};
            this.cache[id].result = null;
            this.cache[id].inputs = [];
        }
        return this.cache[id];
    };
    this.initComponent = function(input, string, params){
        y5.Components.AutoComplete.create(
            input.parentNode,
            input,
            string,
            y5.Components.getName(input.className, this.className),
            params
        );
    };
    this.create = function(element, input, string, type, params){
        var object = {};
        function create(){
            input.setAttribute('autocomplete', 'off');
            object.params = params;
            object.input = input;
            object.autocomplete = new y5.Components.AutoComplete[y5.Strings.capitalize(type)](object);
            object.autocomplete.init(element, params.template ? y5.moduleObject(params.template): null, params.noDefaultSelect);
            object._string_ = string;
            object.string = new y5.Components.AutoComplete.Strings(params.onlybyparent ? '' : string);
            input.setById = function(id){
                y5.Components.AutoComplete.setById(id, object, input);
            };
            input.specify = function(id){
                y5.Components.AutoComplete.specify(id, object, input);
            };
            // Если значение в поле есть, то необходимо получить id значения,
            // чтобы определить возможные значения зависимого поля (если оно есть)
            // Пример: страна-город
            if (input.value.length) {
                var value = y5.Strings.trim(input.value);
                var source = value.length ? object.string.match(value) : null ;
                if (source){
                    object.autocomplete.reload(source, value);
                    var event = object.autocomplete.getEvent();
                    y5.CallBacks.dispatch('change', input, event);
                }
            }

            if (string != '') {
                object.string = new y5.Components.AutoComplete.Strings(string); // specify
            }

            y5.Components.AutoComplete.setEvents(element, object, input);
        }
        var require = ['{y5}.Components.AutoComplete.' + type];
        if (params.template){
            require[require.length] = params.template;
        }
        y5.require(require, create);
    };
    this.specify = function(id, object, input){
        var string = '';
        if (id){
            object.string = new y5.Components.AutoComplete.Strings(object._string_);
            string = object.string.match(id, 'parent');
            string = string ? string.join('') : '';
        }else{
            string = object.params.onlybyparent ? '' :  object._string_;
        }
        object.string = new y5.Components.AutoComplete.Strings(string);
    };
    this.setById = function(value, object, input){
        if(!value || (value && value == input.value)) {
            return;
        }
        var option = object.string.match(value, 'value')[0];
        var e = {};
        e.text = object.string.getText(option);
        e.value = object.string.getValue(option);
        e.parent = object.string.getParent(option);
        y5.CallBacks.dispatch('change', object.autocomplete, e);
    };
    this.setEvents = function(element, object, input){
        var tabKey = false, enterKey = false;
        
        function change(e){
            if (e.closed){
                return;
            }
            input.value = e.text;
            close();
            y5.CallBacks.dispatch('change', input, e);
        }
        y5.CallBacks.add('change', change, object.autocomplete);

        function click(){
            y5.CallBacks.dispatch('click', input);
            input.focus();
        }
        y5.CallBacks.add('click', click, object.autocomplete);
        function enter(e){
            y5.CallBacks.dispatch('keyup', input, {keyCode: y5.ShortCut.ENTER});
            object.autocomplete.change();
            enterKey = true;
        }
        var ShortCutEnter = y5.ShortCut.down([{key:y5.ShortCut.ENTER}], enter, input, {checkTarget: false});
        ShortCutEnter.remove();

        function esc(e){
            y5.CallBacks.dispatch('keyup', input, {keyCode: y5.ShortCut.ESC});
            close();
        }
        y5.ShortCut.down([{key:y5.ShortCut.ESC}], esc, input, false);

        function enableEnter(){
            ShortCutEnter.add();
            CloseClick.add();
            y5.CallBacks.dispatch('open', input);
        }
        y5.CallBacks.add('open', enableEnter, object.autocomplete);

        function reload(value){
            object.autocomplete.open();
            if(object.autocomplete.isOnly(value)){
                object.autocomplete.change();
            }
        }
        y5.CallBacks.add('reload', reload, object.autocomplete);

        function disableEnter(){
            ShortCutEnter.remove();
            CloseClick.remove();
            y5.CallBacks.dispatch('close', input);
        }
        y5.CallBacks.add('close', disableEnter, object.autocomplete);

        function close(){
            object.autocomplete.close();
            // если закрываем через нажатый Tab, т.е. переходим на следующий элемент, то фокус ставить не надо
            if (!input.disabled && !tabKey && input.offsetHeight > 0) {
                try {
                    input.focus();
                } catch (e) {
                    // ignore
                }
            }
        }

        function down(){
            object.autocomplete.down();
        }
        y5.ShortCut.press([{key:y5.ShortCut.DOWN_ARROW}], down, input, false);
        y5.ShortCut.down([{key:y5.ShortCut.DOWN_ARROW}], y5.NULL, input, false);

        function up(){
            object.autocomplete.up();
        }
        y5.ShortCut.press([{key:y5.ShortCut.UP_ARROW}], up, input, false);
        y5.ShortCut.down([{key:y5.ShortCut.UP_ARROW}], y5.NULL, input, false);


        function reloadAutocomplete (){
            var value = y5.Strings.trim(input.value);
            var source = value.length ? object.string.match(value) : null ;
            if (!source){
                object.autocomplete.reload(null, value);
                var event = {
                    value: null,
                    parent: null
                };
                y5.CallBacks.dispatch('change', input, event);
                return;
            }
            object.autocomplete.reload(source, value);
        }
        new y5.InputObserver(reloadAutocomplete, input, true);

        function keypress(e) {
            tabKey = (e.keyCode == y5.ShortCut.TAB);
            if (enterKey && e.keyCode == y5.ShortCut.ENTER) {
                e.preventDefault();
            } else {
                enterKey = false;
            }
        }
        y5.Events.observe('keypress', keypress, input, true);

        function blur(e){
            object.autocomplete.change();
        }
        new y5.AEventListener('blur', blur, input, true);

        function closeClick(e){
            var elem = e.target;
            while (elem && elem != y5.Dom.getBody()){
                if (elem == element){
                    return;
                }
                elem = elem.parentNode;
            }
            object.autocomplete.close();
        }
        var CloseClick = y5.Events.create('click', closeClick, document, false);
    };
};

y5.Components.AutoComplete.Strings = function(string){
    this.setString = function(string){
        this.string = string;
    };
    this.setString(string);
    this.match = function(substr, type){
        return this.string.match(this.getRegExp(substr, type));
    };
    this.getRegExp = function(substr, type){
        switch (type){
            case 'full':
                return new RegExp('<[^>]*>' + y5.Strings.escapeRegexp(substr) + '</[^>]*>', 'ig');
            case 'value':
                return new RegExp('<[^v]*v="'+ y5.Strings.escapeRegexp(substr) +'"[^>]*>[^<]*</[^>]*>', 'i');
            case 'parent':
                return new RegExp('<[^p]*p="'+ y5.Strings.escapeRegexp(substr) +'"[^>]*>[^<]*</[^>]*>', 'ig');
            case 'gettext':
                return new RegExp('<[^>]*>([^<]*)</[^>]*>', 'i');
            case 'getvalue':
                return new RegExp('<[^v]*v="([^"]*)[^>]*>[^<]*</[^>]*>', 'i');
            case 'getstyle':
                return new RegExp('<[^s]*s="([^"]*)[^>]*>[^<]*</[^>]*>', 'i');
            case 'getparent':
                return new RegExp('<[^p]*p="([^"]*)[^>]*>[^<]*</[^>]*>', 'i');
            case 'node':
                return new RegExp('<[^v]*v="([^"]*)[^p]*p="([^"]*)[^>]*>([^<]*)</[^>]*>', 'i');
            default :
                return new RegExp('<[^/>]*>' + y5.Strings.escapeRegexp(substr) + '[^<]*</[^>]*>', 'ig');

        }
        return new RegExp('', '');
    };
    this.getText = function(string){
        return string.match(this.getRegExp('', 'gettext'))[1];
    };
    this.getValue = function(string){
        return string.match(this.getRegExp('', 'getvalue'))[1];
    };
    this.getParent = function(string){
        var parent = string.match(this.getRegExp('', 'getparent'));
        return parent ? parent[1] : '';
    };
    this.getStyle = function(string){
        var style = string.match(this.getRegExp('', 'getstyle'));
        return style ? style[1] : '';
    };
    this.createDataForNode = function(source){
        return {value: this.getValue(source), text: this.getText(source), parent: this.getParent(source), style: this.getStyle(source)};
    };
};

y5.require(['Strings', 'CallBacks', 'ShortCuts', 'Dom', 'Events', 'EventsExt'], function(){y5.loaded('Components.AutoComplete')});