y5.Components.AutoComplete.Divs = function(input){
    this.input = input;
    this.init = function(element, template, noDefaultSelect){
        this.noDefaultSelect = noDefaultSelect;
        this.templates = template ? new template() : new y5.Components.AutoComplete.Divs.Templates();
        this.select = this.templates.apply({}, 'select');
        this.platform = this.select.length ? this.select[0]: this.select;
        this.setEvents(this.platform);
        y5.Dom.getBody().appendChild(this.platform);
        this.select = this.select.length ? this.select[1]: this.select;;
        return this.select;
    };
    this.setEvents = function(select){
        var _this = this;
        function change(e){
            _this.setActive(e.target.index, true);
            y5.CallBacks.dispatch('change', _this, _this.getEvent());
        }
        function click(e){
            change(e);
            y5.CallBacks.dispatch('click', _this);
        }
        y5.Events.create('click', click, select, true);

        function mouseover(e){
            _this.setActive(e.target.index, true);
        }
        y5.Events.create('mouseover', mouseover, select, true);
    };
    this.reload = function(options, trace){
        if (this.timeout){
            window.clearTimeout(this.timeout);
        }
        if (!options || !options.length){
            this.close();
            return;
        }
        this._reload(options, trace);
        /*
        var _this = this;
        this.timeout = window.setTimeout(function(){_this._reload(options)}, 0);
        */
    };
    this._reload = function(options, trace){
        y5.Dom.clearNode(this.select);
        this.setSize(options.length);
        this.select.options = [];
        for (var i = 0,  l = options.length; i < l; i++){
            var option = this.input.string.createDataForNode(options[i]);
            var value = option.value;
            var parent = option.parent;
            option = this.templates.apply(option, 'option');
            option.parent = parent;
            option.index = i;
            option.value = value;
            this.select.appendChild(option);
            this.select.options.push(option);
        }
        // по умолчанию выбранным является первый элемент из найденных. Если есть параметр noDefaultSelect, то значение надо выбрать явно
        if (this.noDefaultSelect) {
            this.setActive(-1, true);
        } else {
            this.setActive(0, true);
        }
        y5.CallBacks.dispatch('reload', this, trace);
    };
    this.open = function(){
        if (this.select.options.length == 0){
            return;
        }

        var input = this.input.input,
            top = y5.Dom.offsetTop(input) + input.offsetHeight - 1,
            left = y5.Dom.offsetLeft(input) - 2,
            width = input.offsetWidth - 2;

        if (y5.is_ie7down) {
            width += 2;
        }

        this.platform.style.cssText = 'display:block;top:'+top+'px;left:'+left+'px;width:'+width+'px !important;';

        y5.CallBacks.dispatch('open', this);
    };
    this.close = function(input){
        this.platform.style.display = 'none';
        y5.CallBacks.dispatch('close', this);
    };
    this.focus = function(){
        this.select.focus();
    };
    this.getEvent = function(){
        var option = this.select.options[this.select.selectedIndex],
            event;
        if (option) {
            event = {
                text: option.firstChild.nodeValue,
                value: option.value,
                parent: option.parent,
                closed: false
            };
        } else {
            event = {
                text: null,
                value: null,
                parent: null,
                closed: true
            };
        }
        return event;
    };
    this.change = function(){
        var event;
        if (this.platform.style.display == 'none'){
            event = {closed: true};
        }else{
            event = this.getEvent();
        }
        y5.CallBacks.dispatch('change', this, event);
        this.close();
    };
    this.up = function(){
        var index = 0;
        if (y5.Types.def(this.select.selectedIndex)) {
            index = Math.max(this.select.selectedIndex -  1, 0);
        }
        this.setActive(index, true);
    };
    this.down = function(){
        var index = 0;
        if (y5.Types.def(this.select.selectedIndex)) {
            index = Math.min(this.select.selectedIndex +  1, this.select.options.length - 1);
        }
        this.setActive(index, false);
    };
    this.isOnly = function(string){
        return this.select.options.length == 1 && y5.Strings.trim(string).toLowerCase() == this.select.options[0].firstChild.nodeValue.toLowerCase();
    };
    this.setActive = function(index, top){
        if(isNaN(index)) return;
        var selected = this.select.selectedIndex;
        if (selected == index && y5.Classes.test(this.select.options[index], this.templates.classes.selected)){
            return;
        }
        if (typeof(selected) != y5.UNDEF && this.select.options[selected]){
            this.select.selectedIndex = undefined;
            y5.Classes.remove(this.select.options[selected], this.templates.classes.selected);
        }
        if (this.select.options[index]){
            y5.Classes.add(this.select.options[index], this.templates.classes.selected);
            this.select.selectedIndex = index;
            top ? this.scrollIntoViewTop() : this.scrollIntoViewBottom();
        }
    };
    this.scrollIntoViewTop = function(){
        if (this.select.selectedIndex == 0 && this.select.scrollTop == 0){
            return;
        }
        var option = this.select.options[this.select.selectedIndex];
        var optionTop = y5.Dom.offsetTop(option) - y5.Dom.offsetTop(this.select);
        if (optionTop <= this.select.scrollTop){
            this.select.scrollTop = optionTop;
        }
        optionTop = null;
    };
    this.scrollIntoViewBottom = function(){
        var option = this.select.options[this.select.selectedIndex];
        var optionBottom = y5.Dom.offsetTop(option) - y5.Dom.offsetTop(this.select) + option.offsetHeight;
        if (optionBottom > this.select.scrollTop + this.select.offsetHeight){
            this.select.scrollTop = optionBottom - this.select.offsetHeight;
        }
        optionBottom = null;
    };
    this.setSize = function(length){
        this.select.style.height = this.templates.getSize(length);
    };
};

y5.Components.AutoComplete.Divs.Templates = function(){
    y5.Styles.createStyle(y5.constructURL('{y5}.Components.AutoComplete.divs', 'css'), true);
    var classes = {
        prefix:       'y5-autocomplete-',
        autocomplete: 'autocomplete',
        selected:     'selected'
    };
    this.classes = new y5.Components.Classes(classes).getClasses();
    this.apply = function(data, template){
        var element = y5.jsonT(data, this.templates(template));
        return y5.Elements.createElementFromHTML(element);
    };
    this.templates = function(template){
        var classes = this.classes;
        var rules = {};
        switch (template){
            case 'select':
                rules = {
                    'self': '<span style="display:none;" class="'+ classes.autocomplete +'"></span>'
                };
                break;
            case 'option':
                rules = {
                    'self': '<span style="{$.style}">{$.text}</span>'
                };
                break;
        }
        return rules;
    };
    this.getSize = function(length){
        var max = 10, min = 1;
        return (Math.min(max, Math.max(min, length)) * 1.4 + (y5.is_opera || y5.is_ie ? 0.5 : 0 )) + 'em';
    };
};

y5.require(['Utils', 'Events', 'Classes', 'ShortCuts', 'Elements', 'Styles', 'jsonT', 'Components.Classes', 'Strings', 'Dom', 'cssQuery'], function(){y5.loaded('Components.AutoComplete.Divs')});
