y5.require(['Utils', 'Dom', 'Events', 'ShortCuts', 'Template', 'Widget.Window'], function() {

var WidgetWindowName = 'Widget.Popup';

/**
 * y5.Widget.Popup
 */
y5.Widget.Popup = function(element, content, params) {
    this.Window(element, content, params);
};

y5.Widget.Popup.prototype = {
    className: 'y5-w-popup',

    /**
     * Опции по умолчанию
     */
    defaultParams: {
        // по вертикали
        halign: 'left',

        // по горизонтали
        valign: 'bottom',

        // отображать заголовок
        showCaption: false,

        // заголовок попапа
        title: ''
    },

    toString: function() {
        return WidgetWindowName;
    },

    cancel: function(e) {
        this.action(e, 'cancel');
    },

    /*
        Events
    */
    setEventsOnce: function() {
        this.button_close = y5.Dom.getElementByClass('y5-w-closebutton', this.window);
        if (this.button_close) {
            this.events.close = new y5.AEventListener('click', this.cancel, this.button_close, false, this);
        }

        // TODO: нужна обработка tab/shift+tab на предмет выхода за пределы попапа, при этом закрывать его
        // TODO: обработка mousedown недостаточна для случая, когда фокус уходит в ифрейм
        this.events.hide_click = new y5.AEventListener('mousedown', this.hide_click, document, false, this);

        this.Window.prototype.setEventsOnce.apply(this);
    },

    hide_click: function(e) {
        // проверяем, что клик произошел вне попапа
        if (!y5.Dom.isChild(e.target, this.window)) {
            this.kill();
        }
    },

    /*
        Shortcuts
    */
    setShortcutsOnce: function() {
        this.shortcuts.esc = y5.ShortCut.down([{key: y5.ShortCut.ESC}], this.esc, document, {checkTarget: false, context: this});

        this.Window.prototype.setShortcutsOnce.apply(this);
    },

    esc: function(e) {
        this.action(e, 'esc');
    }
};

y5.Utils.objectExtends(y5.Widget.Popup, y5.Widget.Window, 'Window');

if (!y5.Widget.Templates.get(WidgetWindowName, 'default')) {
    var template = new y5.Widget.Template(WidgetWindowName, 'Widget.Window', 'default');
    template.loadCSSModule(WidgetWindowName);
}

y5.loaded(WidgetWindowName);

});
